
package ONVIF::Media::Elements::SetOSD;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'http://www.onvif.org/ver10/media/wsdl' }

__PACKAGE__->__set_name('SetOSD');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %OSD_of :ATTR(:get<OSD>);

__PACKAGE__->_factory(
    [ qw(        OSD

    ) ],
    {
        'OSD' => \%OSD_of,
    },
    {
        'OSD' => 'ONVIF::Media::Types::OSDConfiguration',
    },
    {

        'OSD' => 'OSD',
    }
);

} # end BLOCK







} # end of BLOCK



1;


=pod

=head1 NAME

ONVIF::Media::Elements::SetOSD

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
SetOSD from the namespace http://www.onvif.org/ver10/media/wsdl.







=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * OSD

 $element->set_OSD($data);
 $element->get_OSD();





=back


=head1 METHODS

=head2 new

 my $element = ONVIF::Media::Elements::SetOSD->new($data);

Constructor. The following data structure may be passed to new():

 {
   OSD =>  { # ONVIF::Media::Types::OSDConfiguration
     VideoSourceConfigurationToken =>  { value => $some_value },
     Type => $some_value, # OSDType
     Position =>  { # ONVIF::Media::Types::OSDPosConfiguration
       Type =>  $some_value, # string
       Pos => ,
       Extension =>  { # ONVIF::Media::Types::OSDPosConfigurationExtension
       },
     },
     TextString =>  { # ONVIF::Media::Types::OSDTextConfiguration
       Type =>  $some_value, # string
       DateFormat =>  $some_value, # string
       TimeFormat =>  $some_value, # string
       FontSize =>  $some_value, # int
       FontColor =>  { # ONVIF::Media::Types::OSDColor
         Color => ,
       },
       BackgroundColor =>  { # ONVIF::Media::Types::OSDColor
         Color => ,
       },
       PlainText =>  $some_value, # string
       Extension =>  { # ONVIF::Media::Types::OSDTextConfigurationExtension
       },
     },
     Image =>  { # ONVIF::Media::Types::OSDImgConfiguration
       ImgPath =>  $some_value, # anyURI
       Extension =>  { # ONVIF::Media::Types::OSDImgConfigurationExtension
       },
     },
     Extension =>  { # ONVIF::Media::Types::OSDConfigurationExtension
     },
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

