// Copyright 2010 Google Inc.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Raises priority of test process and main thread to reduce
// timing variations caused by context switches. Windows only.

#if defined(_MSC_VER)
// Disable warnings generated by "windows.h" compiled with -Wall.

// N bytes padding added after data member X
#pragma warning(disable: 4820)

// no function prototype given: converting '()' to '(void)'
#pragma warning(disable: 4255)

// '__midl' is not defined as a preprocessor macro,
// replacing with '0' for '#if/#elif'
#pragma warning(disable: 4668)

#endif  // defined(_MSC_VER)


#if defined(_WIN32)
#include <windows.h>
#endif  // defined(_WIN32)

#ifdef __cplusplus
extern "C"
#endif  // __cplusplus
void SetHiPri(void)
{
#if defined(_WIN32)
#if 1
  // These setting are extremely dangerous. E.g. if app hits infinite loop,
  // computer may turn unresponsive and will require a power cycle.
  // Use for final testing only.
  SetThreadPriority(GetCurrentThread(), THREAD_PRIORITY_TIME_CRITICAL);
  SetPriorityClass(GetCurrentProcess(), REALTIME_PRIORITY_CLASS);
#else
  SetThreadPriority(GetCurrentThread(), THREAD_PRIORITY_HIGHEST);
  SetPriorityClass(GetCurrentProcess(), HIGH_PRIORITY_CLASS);
#endif
#endif  // defined(_WIN32)
}
