from click.testing import CliRunner

from fiona.fio import filter

from .fixtures import feature_seq


def test_fail():
    runner = CliRunner()
    result = runner.invoke(filter.filter,
                           ["f.properties.test > 5"],
                           "{'type': 'no_properties'}")
    assert result.exit_code == 1


def test_seq():
    runner = CliRunner()

    result = runner.invoke(filter.filter, ["f.properties.AREA > 0.01"], feature_seq)
    assert result.exit_code == 0
    assert result.output.count('Feature') == 2

    result = runner.invoke(filter.filter, ["f.properties.AREA > 0.015"], feature_seq)
    assert result.exit_code == 0
    assert result.output.count('Feature') == 1

    result = runner.invoke(filter.filter, ["f.properties.AREA > 0.02"], feature_seq)
    assert result.exit_code == 0
    assert result.output.count('Feature') == 0
