/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.hdf5lib;

import java.io.File;
import ncsa.hdf.hdf5lib.HDF5GroupInfo;
import ncsa.hdf.hdf5lib.HDFArray;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;

public class H5 {
    public static final String H5PATH_PROPERTY_KEY = "ncsa.hdf.hdf5lib.H5.hdf5lib";

    public static native int J2C(int var0);

    private static native int H5error_off();

    public static native int H5open() throws HDF5LibraryException;

    public static native int H5close() throws HDF5LibraryException;

    private static native int H5dont_atexit() throws HDF5LibraryException;

    public static native int H5get_libversion(int[] var0) throws HDF5LibraryException;

    public static native int H5check_version(int var0, int var1, int var2);

    public static native int H5Eclear() throws HDF5LibraryException;

    public static native int H5Acreate(int var0, String var1, int var2, int var3, int var4) throws HDF5LibraryException, NullPointerException;

    public static native int H5Aopen_name(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Aopen_idx(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Awrite(int var0, int var1, byte[] var2) throws HDF5LibraryException, NullPointerException;

    public static int H5Awrite(int attr_id, int mem_type_id, Object obj) throws HDF5Exception, NullPointerException {
        HDFArray theArray = new HDFArray(obj);
        byte[] buf = theArray.byteify();
        int retVal = H5.H5Awrite(attr_id, mem_type_id, buf);
        buf = null;
        theArray = null;
        return retVal;
    }

    public static native int H5Aread(int var0, int var1, byte[] var2) throws HDF5LibraryException, NullPointerException;

    public static int H5Aread(int attr_id, int mem_type_id, Object obj) throws HDF5Exception, NullPointerException {
        HDFArray theArray = new HDFArray(obj);
        byte[] buf = theArray.emptyBytes();
        int status = H5.H5Aread(attr_id, mem_type_id, buf);
        if (status >= 0) {
            obj = theArray.arrayify(buf);
        }
        return status;
    }

    public static native int H5Aget_space(int var0) throws HDF5LibraryException;

    public static native int H5Aget_type(int var0) throws HDF5LibraryException;

    public static native long H5Aget_name(int var0, long var1, String[] var3) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Aget_num_attrs(int var0) throws HDF5LibraryException;

    public static native int H5Adelete(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Aclose(int var0) throws HDF5LibraryException;

    public static native int H5Dcreate(int var0, String var1, int var2, int var3, int var4) throws HDF5LibraryException, NullPointerException;

    public static native int H5Dopen(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Dget_space(int var0) throws HDF5LibraryException;

    public static native int H5Dget_type(int var0) throws HDF5LibraryException;

    public static native int H5Dget_create_plist(int var0) throws HDF5LibraryException;

    public static native int H5Dread(int var0, int var1, int var2, int var3, int var4, byte[] var5) throws HDF5LibraryException, NullPointerException;

    public static int H5Dread(int dataset_id, int mem_type_id, int mem_space_id, int file_space_id, int xfer_plist_id, Object obj) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        HDFArray theArray = new HDFArray(obj);
        byte[] buf = theArray.emptyBytes();
        int status = H5.H5Dread(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, buf);
        if (status >= 0) {
            obj = theArray.arrayify(buf);
        }
        buf = null;
        theArray = null;
        return status;
    }

    public static native int H5Dwrite(int var0, int var1, int var2, int var3, int var4, byte[] var5) throws HDF5LibraryException, NullPointerException;

    public static int H5Dwrite(int dataset_id, int mem_type_id, int mem_space_id, int file_space_id, int xfer_plist_id, Object obj) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        HDFArray theArray = new HDFArray(obj);
        byte[] buf = theArray.byteify();
        int status = H5.H5Dwrite(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, buf);
        buf = null;
        theArray = null;
        return status;
    }

    public static native int H5Dextend(int var0, long[] var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Dclose(int var0) throws HDF5LibraryException;

    public static native long H5Dget_storage_size(int var0) throws HDF5LibraryException;

    public static native int H5Fopen(String var0, int var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Fcreate(String var0, int var1, int var2, int var3) throws HDF5LibraryException, NullPointerException;

    public static native int H5Fflush(int var0, int var1) throws HDF5LibraryException;

    public static native boolean H5Fis_hdf5(String var0) throws HDF5LibraryException, NullPointerException;

    public static native int H5Fget_create_plist(int var0) throws HDF5LibraryException;

    public static native int H5Fget_access_plist(int var0) throws HDF5LibraryException;

    public static native int H5Fclose(int var0) throws HDF5LibraryException;

    public static native int H5Fmount(int var0, String var1, int var2, int var3) throws HDF5LibraryException, NullPointerException;

    public static native int H5Funmount(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Freopen(int var0) throws HDF5LibraryException;

    public static native int H5Gcreate(int var0, String var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Gopen(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Gclose(int var0) throws HDF5LibraryException;

    public static native int H5Glink(int var0, int var1, String var2, String var3) throws HDF5LibraryException, NullPointerException;

    public static native int H5Gunlink(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Gn_members(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Gget_obj_info_idx(int var0, String var1, int var2, String[] var3, int[] var4) throws HDF5LibraryException, NullPointerException;

    public static native int H5Gmove(int var0, String var1, String var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Gget_objinfo(int var0, String var1, boolean var2, long[] var3, long[] var4, int[] var5, long[] var6) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static int H5Gget_objinfo(int loc_id, String name, boolean follow_link, HDF5GroupInfo info) throws HDF5LibraryException, NullPointerException {
        int status = -1;
        long[] fileno = new long[2];
        long[] objno = new long[2];
        int[] link_info = new int[3];
        long[] mtime = new long[1];
        status = H5.H5Gget_objinfo(loc_id, name, follow_link, fileno, objno, link_info, mtime);
        if (status >= 0) {
            info.setGroupInfo(fileno, objno, link_info[0], link_info[1], mtime[0], link_info[2]);
        }
        return status;
    }

    public static native int H5Gget_linkval(int var0, String var1, int var2, String[] var3) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Gset_comment(int var0, String var1, String var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Gget_comment(int var0, String var1, int var2, String[] var3) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Iget_type(int var0) throws HDF5LibraryException;

    public static native int H5Pcreate(int var0) throws HDF5LibraryException;

    public static native int H5Pclose(int var0) throws HDF5LibraryException;

    public static native int H5Pget_class(int var0) throws HDF5LibraryException;

    public static native int H5Pcopy(int var0) throws HDF5LibraryException;

    public static native int H5Pget_version(int var0, int[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Pset_userblock(int var0, long var1) throws HDF5LibraryException;

    public static native int H5Pget_userblock(int var0, long[] var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pset_sizes(int var0, int var1, int var2) throws HDF5LibraryException;

    public static native int H5Pget_sizes(int var0, int[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Pset_sym_k(int var0, int var1, int var2) throws HDF5LibraryException;

    public static native int H5Pget_sym_k(int var0, int[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Pset_istore_k(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Pget_istore_k(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pset_layout(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Pget_layout(int var0) throws HDF5LibraryException;

    public static native int H5Pset_chunk(int var0, int var1, long[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Pget_chunk(int var0, int var1, long[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Pset_alignment(int var0, long var1, long var3) throws HDF5LibraryException;

    public static native int H5Pget_alignment(int var0, long[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Pset_external(int var0, String var1, long var2, long var4) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pget_external_count(int var0) throws HDF5LibraryException;

    public static native int H5Pget_external(int var0, int var1, int var2, String[] var3, long[] var4) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Pset_fill_value(int var0, int var1, byte[] var2) throws HDF5Exception;

    public static int H5Pset_fill_value(int plist_id, int type_id, Object obj) throws HDF5Exception {
        HDFArray theArray = new HDFArray(obj);
        byte[] buf = theArray.byteify();
        int retVal = H5.H5Pset_fill_value(plist_id, type_id, buf);
        buf = null;
        theArray = null;
        return retVal;
    }

    public static native int H5Pget_fill_value(int var0, int var1, byte[] var2) throws HDF5Exception;

    public static int H5Pget_fill_value(int plist_id, int type_id, Object obj) throws HDF5Exception {
        HDFArray theArray = new HDFArray(obj);
        byte[] buf = theArray.emptyBytes();
        int status = H5.H5Pget_fill_value(plist_id, type_id, buf);
        if (status >= 0) {
            obj = theArray.arrayify(buf);
        }
        return status;
    }

    public static native int H5Pset_filter(int var0, int var1, int var2, int var3, int[] var4) throws HDF5LibraryException;

    public static native int H5Pget_nfilters(int var0) throws HDF5LibraryException;

    public static native int H5Pget_filter(int var0, int var1, int[] var2, int[] var3, int[] var4, int var5, String[] var6) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException;

    public static native int H5Pget_driver(int var0) throws HDF5LibraryException;

    public static native int H5Pset_stdio(int var0) throws HDF5LibraryException;

    public static native boolean H5Pget_stdio(int var0);

    public static native int H5Pset_sec2(int var0) throws HDF5LibraryException;

    public static native boolean H5Pget_sec2(int var0) throws HDF5LibraryException;

    public static native int H5Pset_core(int var0, int var1) throws HDF5LibraryException;

    public static native boolean H5Pget_core(int var0, int[] var1) throws HDF5LibraryException;

    public static native int H5Pset_split(int var0, String var1, int var2, String var3, int var4) throws HDF5LibraryException, NullPointerException;

    public static native boolean H5Pget_split(int var0, int var1, String[] var2, int[] var3, int var4, String[] var5, int[] var6) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException;

    public static native int H5Pset_family(int var0, long var1, int var3) throws HDF5LibraryException;

    public static native int H5Pget_family(int var0, long[] var1, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pset_cache(int var0, int var1, int var2, int var3, double var4) throws HDF5LibraryException;

    public static native int H5Pget_cache(int var0, int[] var1, int[] var2, int[] var3, double[] var4) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pset_preserve(int var0, boolean var1) throws HDF5LibraryException, IllegalArgumentException;

    public static native int H5Pget_preserve(int var0) throws HDF5LibraryException;

    public static native boolean H5Pset_deflate(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Pset_gc_references(int var0, boolean var1) throws HDF5LibraryException;

    public static native int H5Pget_gc_reference(int var0, boolean[] var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pset_hyper_cache(int var0, boolean var1, int var2) throws HDF5LibraryException;

    public static native int H5Pget_hyper_cache(int var0, boolean[] var1, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pset_btree_ratios(int var0, double var1, double var3, double var5) throws HDF5LibraryException;

    public static native int H5Pget_btree_ratios(int var0, double[] var1, double[] var2, double[] var3) throws HDF5LibraryException, NullPointerException;

    private static native int H5Rcreate(byte[] var0, int var1, String var2, int var3, int var4) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static byte[] H5Rcreate(int loc_id, String name, int ref_type, int space_id) throws HDF5LibraryException, NullPointerException, IllegalArgumentException {
        int ref_size = 8;
        if (ref_type == 1) {
            ref_size = 12;
        }
        byte[] rbuf = new byte[ref_size];
        H5.H5Rcreate(rbuf, loc_id, name, ref_type, space_id);
        return rbuf;
    }

    public static native int H5Rdereference(int var0, int var1, byte[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Rget_region(int var0, int var1, byte[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Rget_object_type(int var0, byte[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Screate(int var0) throws HDF5LibraryException;

    public static native int H5Screate_simple(int var0, long[] var1, long[] var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Scopy(int var0) throws HDF5LibraryException;

    private static native int H5Sselect_elements(int var0, int var1, int var2, byte[] var3) throws HDF5LibraryException, NullPointerException;

    public static int H5Sselect_elements(int space_id, int op, int num_elements, long[][] coord2D) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        if (coord2D == null) {
            return -1;
        }
        HDFArray theArray = new HDFArray(coord2D);
        byte[] coord = theArray.byteify();
        int retVal = H5.H5Sselect_elements(space_id, op, num_elements, coord);
        coord = null;
        theArray = null;
        return retVal;
    }

    public static native int H5Sselect_all(int var0) throws HDF5LibraryException;

    public static native int H5Sselect_none(int var0) throws HDF5LibraryException;

    public static native boolean H5Sselect_valid(int var0) throws HDF5LibraryException;

    public static native long H5Sget_simple_extent_npoints(int var0) throws HDF5LibraryException;

    public static native long H5Sget_select_npoints(int var0) throws HDF5LibraryException;

    public static native int H5Sget_simple_extent_ndims(int var0) throws HDF5LibraryException;

    public static native int H5Sget_simple_extent_dims(int var0, long[] var1, long[] var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Sget_simple_extent_type(int var0) throws HDF5LibraryException;

    public static native int H5Sset_extent_simple(int var0, int var1, long[] var2, long[] var3) throws HDF5LibraryException, NullPointerException;

    public static native boolean H5Sis_simple(int var0) throws HDF5LibraryException;

    public static native int H5Soffset_simple(int var0, long[] var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Sextent_copy(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Sset_extent_none(int var0) throws HDF5LibraryException;

    public static native int H5Sselect_hyperslab(int var0, int var1, long[] var2, long[] var3, long[] var4, long[] var5) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Sclose(int var0) throws HDF5LibraryException;

    public static native long H5Sget_select_hyper_nblocks(int var0) throws HDF5LibraryException;

    public static native long H5Sget_select_elem_npoints(int var0) throws HDF5LibraryException;

    public static native int H5Sget_select_hyper_blocklist(int var0, long var1, long var3, long[] var5) throws HDF5LibraryException, NullPointerException;

    public static native int H5Sget_select_elem_pointlist(int var0, long var1, long var3, long[] var5) throws HDF5LibraryException, NullPointerException;

    public static native int H5Sget_select_bounds(int var0, long[] var1, long[] var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Topen(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Tcommit(int var0, String var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static native boolean H5Tcommitted(int var0) throws HDF5LibraryException;

    public static native int H5Tcreate(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tcopy(int var0) throws HDF5LibraryException;

    public static native boolean H5Tequal(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tlock(int var0) throws HDF5LibraryException;

    public static native int H5Tget_class(int var0) throws HDF5LibraryException;

    public static native int H5Tget_size(int var0) throws HDF5LibraryException;

    public static native int H5Tset_size(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tget_order(int var0) throws HDF5LibraryException;

    public static native int H5Tset_order(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tget_precision(int var0) throws HDF5LibraryException;

    public static native int H5Tset_precision(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tget_offset(int var0) throws HDF5LibraryException;

    public static native int H5Tset_offset(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tget_pad(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Tset_pad(int var0, int var1, int var2) throws HDF5LibraryException;

    public static native int H5Tget_sign(int var0) throws HDF5LibraryException;

    public static native int H5Tset_sign(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tget_fields(int var0, int[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Tset_fields(int var0, int var1, int var2, int var3, int var4, int var5) throws HDF5LibraryException;

    public static native int H5Tget_ebias(int var0) throws HDF5LibraryException;

    public static native int H5Tset_ebias(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tget_norm(int var0) throws HDF5LibraryException;

    public static native int H5Tset_norm(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tget_inpad(int var0) throws HDF5LibraryException;

    public static native int H5Tset_inpad(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tget_cset(int var0) throws HDF5LibraryException;

    public static native int H5Tset_cset(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tget_strpad(int var0) throws HDF5LibraryException;

    public static native int H5Tset_strpad(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tget_nmembers(int var0) throws HDF5LibraryException;

    public static native String H5Tget_member_name(int var0, int var1);

    public static native int H5Tget_member_dims(int var0, int var1, int[] var2, int[] var3) throws HDF5LibraryException, NullPointerException;

    public static native int H5Tget_member_type(int var0, int var1) throws HDF5LibraryException;

    public static native long H5Tget_member_offset(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tinsert(int var0, String var1, long var2, int var4) throws HDF5LibraryException, NullPointerException;

    public static native int H5Tpack(int var0) throws HDF5LibraryException;

    public static native int H5Tinsert_array(int var0, String var1, int var2, int var3, int[] var4, int[] var5, int var6) throws HDF5LibraryException, NullPointerException;

    public static native int H5Tclose(int var0) throws HDF5LibraryException;

    public static native int H5Tenum_create(int var0) throws HDF5LibraryException;

    public static native int H5Tenum_insert(int var0, String var1, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Tenum_nameof(int var0, int[] var1, String[] var2, int var3) throws HDF5LibraryException, NullPointerException;

    public static native int H5Tenum_valueof(int var0, String var1, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Tvlen_create(int var0) throws HDF5LibraryException;

    public static native int H5Tset_tag(int var0, String var1) throws HDF5LibraryException;

    public static native String H5Tget_tag(int var0) throws HDF5LibraryException;

    public static native int H5Tget_super(int var0) throws HDF5LibraryException;

    public static native int H5Tget_member_value(int var0, int var1, int[] var2) throws HDF5LibraryException, NullPointerException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        String filename = null;
        filename = System.getProperty(H5PATH_PROPERTY_KEY, null);
        if (filename != null && filename.length() > 0) {
            File h5dll = new File(filename);
            if (!h5dll.exists() || !h5dll.canRead() || !h5dll.isFile()) throw new UnsatisfiedLinkError("Invalid HDF5 library, " + filename);
            System.load(filename);
        } else {
            System.loadLibrary("jhdf5");
        }
        try {
            H5.H5dont_atexit();
        }
        catch (HDF5LibraryException e) {
            System.exit(1);
        }
        H5.H5error_off();
        Integer majnum = Integer.getInteger("ncsa.hdf.hdf5lib.H5.hdf5maj", null);
        Integer minnum = Integer.getInteger("ncsa.hdf.hdf5lib.H5.hdf5min", null);
        Integer relnum = Integer.getInteger("ncsa.hdf.hdf5lib.H5.hdf5rel", null);
        if (majnum == null || minnum == null || relnum == null) return;
        H5.H5check_version(majnum, minnum, relnum);
    }
}

