/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;

public class FitsReader
extends FormatReader {
    private int count;

    public FitsReader() {
        super("Flexible Image Transport System", "fits");
    }

    public boolean isThisType(byte[] block) {
        return true;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length);
        this.in.seek(2880 + 2880 * ((this.count * 80 - 1) / 2880));
        int line = this.core.sizeX[0] * FormatTools.getBytesPerPixel(this.core.pixelType[0]);
        for (int y = this.core.sizeY[0] - 1; y >= 0; --y) {
            this.in.read(buf, y * line, line);
        }
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.count = 1;
        String line = this.in.readString(80);
        if (!line.startsWith("SIMPLE")) {
            throw new FormatException("Unsupported FITS file.");
        }
        while (true) {
            int ndx;
            ++this.count;
            line = this.in.readString(80);
            int comment = line.indexOf("/", ndx = line.indexOf("="));
            if (comment < 0) {
                comment = line.length();
            }
            String key = "";
            String value = "";
            if (ndx >= 0) {
                key = line.substring(0, ndx).trim();
                value = line.substring(ndx + 1, comment).trim();
            } else {
                key = line.trim();
            }
            if (key.equals("END")) break;
            if (key.equals("BITPIX")) {
                int bits = Integer.parseInt(value);
                switch (bits) {
                    case 8: {
                        this.core.pixelType[0] = 1;
                        break;
                    }
                    case 16: {
                        this.core.pixelType[0] = 3;
                        break;
                    }
                    case 32: {
                        this.core.pixelType[0] = 5;
                        break;
                    }
                    case -32: {
                        this.core.pixelType[0] = 6;
                        break;
                    }
                    default: {
                        throw new FormatException("Unsupported pixel type: " + bits);
                    }
                }
            } else if (key.equals("NAXIS1")) {
                this.core.sizeX[0] = Integer.parseInt(value);
            } else if (key.equals("NAXIS2")) {
                this.core.sizeY[0] = Integer.parseInt(value);
            } else if (key.equals("NAXIS3")) {
                this.core.sizeZ[0] = Integer.parseInt(value);
            }
            this.addMeta(key, value);
        }
        this.core.sizeC[0] = 1;
        this.core.sizeT[0] = 1;
        if (this.core.sizeZ[0] == 0) {
            this.core.sizeZ[0] = 1;
        }
        this.core.imageCount[0] = this.core.sizeZ[0];
        this.core.rgb[0] = false;
        this.core.littleEndian[0] = false;
        this.core.interleaved[0] = false;
        this.core.currentOrder[0] = "XYZCT";
        this.core.indexed[0] = false;
        this.core.falseColor[0] = false;
        this.core.metadataComplete[0] = true;
        MetadataStore store = this.getMetadataStore();
        store.setImage(this.currentId, null, null, null);
        FormatTools.populatePixels(store, this);
        store.setLogicalChannel(0, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }
}

