#pragma once

#include "../JuceLibraryCode/JuceHeader.h"
#include "PluginProcessor.h"


//==============================================================================
/**
*/
class SawtoothSynthAudioProcessorEditor  : public AudioProcessorEditor
{
public:
    SawtoothSynthAudioProcessorEditor (SawtoothSynthAudioProcessor&);
    ~SawtoothSynthAudioProcessorEditor();

    //==============================================================================
    void paint (Graphics&) override;
    void resized() override;

private:
    Slider frequencySlider;
    Slider gainSlider;
    Slider cutoffSlider;
    ToggleButton onOffButton;
    
    Label frequencyLabel;
    Label gainLabel;
    Label cutoffLabel;
    Label onOffLabel;
  
    // This reference is provided as a quick way for your editor to
    // access the processor object that created it.
    SawtoothSynthAudioProcessor& processor;

    JUCE_DECLARE_NON_COPYABLE_WITH_LEAK_DETECTOR (SawtoothSynthAudioProcessorEditor)
};
