/* $Id$ 
 *
 * IMul: integer multiplication (intermediate opcode)
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */


#ifndef __IMUL_HPP_INCLUDED
#define __IMUL_HPP_INCLUDED

#include "intermediate/opcodes/OpCode.hpp"
#include "intermediate/operands/Register.hpp"
#include <cassert>

namespace intermediate {


//! integer multiplication
/** This class will perform an integer multiplication.
 *  The main use of it is for determining sizes/offsets of arrays.
 *
 *  In case that left * right is a bigger value than dst can store, the
 *  result is undefined.
 *
 *  Read Operands: left, right
 *  Write Operands: dst
 *
 *  left operand: one multiplication operand (any type).
 *  right operand: one multiplication operand (any type)
 *  dst: direct operand (any type)
 *
 *  Operation: dst = left * right
 */
class IMul : public OpCode {
public:
	//! c'tor
	/** @param l left operand
	 *  @param r right operand
	 *  @param dst destination register
	 */
	IMul(
		Operand *l, 
		Operand *r,
		Register *destination
		) :	left(l), right(r), dst(destination) {}

	//! Accept a Visitor.
 	/** All intermediate code nodes need to implement this method.
         *
         *  @param v the Visitor that can visit this node.
         */
	virtual void accept(Visitor& v) {
		v.visit(*this);
	}

	//! left operand
	Operand *left;
	//! right operand
	Operand *right;
	//! destination
	Register *dst;

protected:
	virtual ~IMul() {
		util::MiscUtil::terminate(this->left);
		util::MiscUtil::terminate(this->right);
		util::MiscUtil::terminate(this->dst);
	}
};

}; /* namespace intermediate */

#endif /* __IMUL_HPP_INCLUDED */
