/* $Id: ConditionedStat.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __CONDITIONED_STAT_HPP_INCLUDED
#define __CONDITIONED_STAT_HPP_INCLUDED

#include "frontend/ast/SeqStat.hpp"
#include "frontend/ast/Expression.hpp"

namespace ast {

//! Sequential statement with a condition.
/** This class defines a sequential statement, that will get evaluated only,
 *  if the condition evaluates to true, or is NULL.
 *  Abstract class.
 */
class ConditionedStat : public SeqStat {
public:
	//! c'tor
	/** @param cond condition (may be NULL), has a boolean result.
	 *  @param loc location of the ConditionedStat.
          */
	ConditionedStat(
		Expression *cond,
		Location loc
		) :	SeqStat(loc), 
			condition(cond) {}
	
	/** condition, that may either be NULL, or needs to evaluate to
          * a boolean value. If it's present, the SeqStat will only get
          * evaluated, if the condition is true.
          */
	Expression *condition;

protected:
	/** Destructor */
	virtual ~ConditionedStat() {
		util::MiscUtil::terminate(condition);
	}
};

}; /* namespace ast */

#endif /* __CONDITIONED_STAT_HPP_INCLUDED */
