#include "SDL_opengl.h"
#include "plane1.h"


#include <iostream>

namespace models {

static GLuint plane1_dl=0;

void plane1::draw() {
	dldraw();
}
void plane1::dldraw() {
	if (plane1_dl==0) { sdraw(); return; }
	glCallList(plane1_dl);
}

void plane1::gen_dl() {
	plane1_dl=glGenLists(1);
	glNewList(plane1_dl,GL_COMPILE);
	sdraw();
	glEndList();
	std::cout << " loaded plane1 " << plane1_dl << std::endl;
}
namespace mtl_plane1 {
typedef enum MTL {
m_hull,
m_klappen,
m_windows,
m_last
};
} //namespace
void plane1::material (int id) {
	switch (id) {
		case mtl_plane1::m_hull:
static const GLfloat m_hull_diffuse[] = {0.860140,0.860140,0.860140};
			glMaterialfv(GL_FRONT,GL_DIFFUSE, m_hull_diffuse);
static const GLfloat m_hull_ambient[] = {0.886780,0.886780,0.886780};
			glMaterialfv(GL_FRONT,GL_AMBIENT, m_hull_ambient);
static const GLfloat m_hull_emissive[] = {0.00000e+0,0.00000e+0,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_EMISSION, m_hull_emissive);
			break;
		case mtl_plane1::m_klappen:
static const GLfloat m_klappen_diffuse[] = {0.620000,0.00000e+0,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_DIFFUSE, m_klappen_diffuse);
static const GLfloat m_klappen_ambient[] = {0.513333,0.00000e+0,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_AMBIENT, m_klappen_ambient);
static const GLfloat m_klappen_emissive[] = {0.00000e+0,0.00000e+0,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_EMISSION, m_klappen_emissive);
			break;
		case mtl_plane1::m_windows:
static const GLfloat m_windows_diffuse[] = {1.00000,1.00000,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_DIFFUSE, m_windows_diffuse);
static const GLfloat m_windows_ambient[] = {1.00000,1.00000,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_AMBIENT, m_windows_ambient);
static const GLfloat m_windows_emissive[] = {0.00000e+0,0.00000e+0,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_EMISSION, m_windows_emissive);
			break;
	}
}
float plane1::minx() { return -0.615991 ; }
float plane1::miny() { return -0.163838 ; }
float plane1::minz() { return -0.589752 ; }
float plane1::maxx() { return 0.615991; }
float plane1::maxy() { return 0.163838; }
float plane1::maxz() { return 0.589752; }
float plane1::radius() { return 0.868387; }
void plane1::sdraw() {
const float vertices[96][3]={
	{0.26200000,1.6147493e-2,0.25858430},
	{9.1059556e-2,-0.13709340,0.25858430},
	{0.26200000,1.6147493e-2,-0.26541570},
	{0.61599111,-0.13849073,-0.26541570},
	{-1.3647772e-16,-0.16271117,0.25858430},
	{-2.1758781e-16,1.6147493e-2,0.58975230},
	{2.8252186e-17,-8.1200062e-2,-0.41399881},
	{-5.4112769e-17,-0.10297710,-7.7707259e-2},
	{-1.0025768e-16,0.16024441,0.11069985},
	{0.29087822,-5.8376951e-2,-3.4157037e-3},
	{2.6601349e-2,3.5817404e-3,0.53841056},
	{9.9484318e-2,-0.11907042,0.27334769},
	{0.23630299,3.5817404e-3,0.27334769},
	{0.23730235,2.0445340e-2,0.26380015},
	{1.6351784e-2,0.15213621,0.13908583},
	{1.6351784e-2,2.0445340e-2,0.54308167},
	{3.3749482e-2,-4.3920130e-3,0.54406572},
	{0.10663245,-0.12704417,0.27900286},
	{0.24345112,-4.3920130e-3,0.27900286},
	{0.23974721,3.2147428e-2,0.26573438},
	{1.8796650e-2,0.16383830,0.14102006},
	{1.8796650e-2,3.2147428e-2,0.54501590},
	{0.24511556,2.2968182e-2,-0.58975230},
	{0.12931156,-9.4841440e-2,-0.58975230},
	{0.12931156,2.2968182e-2,-0.58975230},
	{0.30799556,-0.10984540,-0.33970726},
	{0.13100000,1.6147493e-2,-0.26541570},
	{-5.4198328e-17,0.10278216,-7.7357926e-2},
	{6.4655778e-2,3.0615948e-2,-0.41663838},
	{0.22462924,1.4379263e-2,-0.58975230},
	{0.13790047,-7.3851568e-2,-0.58975230},
	{0.13790047,1.4379263e-2,-0.58975230},
	{0.22462924,1.4379263e-2,-0.56972148},
	{0.13790047,-7.3851568e-2,-0.56972148},
	{0.13790047,1.4379263e-2,-0.56972148},
	{-1.2930292e-17,-0.11054406,-0.24585304},
	{0.29943689,-8.4111173e-2,-0.17156148},
	{1.8845854e-2,-0.10581620,-0.22009636},
	{0.27881934,-8.7053874e-2,-0.15572400},
	{0.27130222,-6.0375425e-2,-2.9152401e-2},
	{2.0428909e-2,-9.8185102e-2,-9.3535382e-2},
	{1.8845854e-2,-7.7218517e-2,-0.22009636},
	{0.27881934,-5.8456192e-2,-0.15572400},
	{0.27130222,-3.1777743e-2,-2.9152401e-2},
	{2.0428909e-2,-6.9587421e-2,-9.3535382e-2},
	{9.1059556e-3,-0.15565421,0.26690742},
	{7.9671972e-2,-0.13580187,0.26690742},
	{9.1059556e-3,-1.7048833e-2,0.52354393},
	{1.1408385e-2,-0.16383830,0.27132752},
	{8.1974402e-2,-0.14398597,0.27132752},
	{1.1408385e-2,-2.5232925e-2,0.52796403},
	{-1.2973071e-17,1.0791049e-2,-0.24567837},
	{-0.26200000,1.6147493e-2,0.25858430},
	{-9.1059556e-2,-0.13709340,0.25858430},
	{-0.26200000,1.6147493e-2,-0.26541570},
	{-0.61599111,-0.13849073,-0.26541570},
	{-0.29087822,-5.8376951e-2,-3.4157037e-3},
	{-2.6601349e-2,3.5817404e-3,0.53841056},
	{-9.9484318e-2,-0.11907042,0.27334769},
	{-0.23630299,3.5817404e-3,0.27334769},
	{-0.23730235,2.0445340e-2,0.26380015},
	{-1.6351784e-2,0.15213621,0.13908583},
	{-1.6351784e-2,2.0445340e-2,0.54308167},
	{-3.3749482e-2,-4.3920130e-3,0.54406572},
	{-0.10663245,-0.12704417,0.27900286},
	{-0.24345112,-4.3920130e-3,0.27900286},
	{-0.23974721,3.2147428e-2,0.26573438},
	{-1.8796650e-2,0.16383830,0.14102006},
	{-1.8796650e-2,3.2147428e-2,0.54501590},
	{-0.24511556,2.2968182e-2,-0.58975230},
	{-0.12931156,-9.4841440e-2,-0.58975230},
	{-0.12931156,2.2968182e-2,-0.58975230},
	{-0.30799556,-0.10984540,-0.33970726},
	{-0.13100000,1.6147493e-2,-0.26541570},
	{-6.4655778e-2,3.0615948e-2,-0.41663838},
	{-0.22462924,1.4379263e-2,-0.58975230},
	{-0.13790047,-7.3851568e-2,-0.58975230},
	{-0.13790047,1.4379263e-2,-0.58975230},
	{-0.22462924,1.4379263e-2,-0.56972148},
	{-0.13790047,-7.3851568e-2,-0.56972148},
	{-0.13790047,1.4379263e-2,-0.56972148},
	{-0.29943689,-8.4111173e-2,-0.17156148},
	{-1.8845854e-2,-0.10581620,-0.22009636},
	{-0.27881934,-8.7053874e-2,-0.15572400},
	{-0.27130222,-6.0375425e-2,-2.9152401e-2},
	{-2.0428909e-2,-9.8185102e-2,-9.3535382e-2},
	{-1.8845854e-2,-7.7218517e-2,-0.22009636},
	{-0.27881934,-5.8456192e-2,-0.15572400},
	{-0.27130222,-3.1777743e-2,-2.9152401e-2},
	{-2.0428909e-2,-6.9587421e-2,-9.3535382e-2},
	{-9.1059556e-3,-0.15565421,0.26690742},
	{-7.9671972e-2,-0.13580187,0.26690742},
	{-9.1059556e-3,-1.7048833e-2,0.52354393},
	{-1.1408385e-2,-0.16383830,0.27132752},
	{-8.1974402e-2,-0.14398597,0.27132752},
	{-1.1408385e-2,-2.5232925e-2,0.52796403},
};
const float normals[96][3]={
	{0.86124044,0.19354226,0.46990030},
	{0.44128491,-0.82737129,0.34745414},
	{0.44557832,0.86912575,-0.21466344},
	{0.63746204,-0.60024095,-0.48306620},
	{-9.9754998e-17,-0.96111371,0.27615292},
	{-4.1583929e-16,-0.44326937,0.89638846},
	{3.2723171e-16,-0.66324061,-0.74840624},
	{-2.3694952e-17,-0.99835403,-5.7351778e-2},
	{-4.0118740e-17,0.99093992,0.13430588},
	{0.16603228,-0.97949042,0.11415690},
	{0.44600548,-0.57602802,0.68503345},
	{0.29943693,-0.95257435,5.4218418e-2},
	{0.89151854,-0.40476382,0.20337389},
	{0.75035097,0.65984450,3.9732434e-2},
	{9.3572596e-2,0.98436917,-0.14920289},
	{0.11567190,0.84839789,0.51656658},
	{0.29313008,-0.46907267,0.83309398},
	{7.8601701e-2,-0.97656991,-0.20033220},
	{0.98438195,-0.17594065,-6.0886741e-3},
	{0.92598531,0.37724245,1.5470437e-2},
	{-8.6661463e-2,0.90634138,-0.41356389},
	{0.11349856,0.64951800,0.75182741},
	{0.47015925,0.50809691,-0.72165629},
	{-7.9274763e-2,-0.46306430,-0.88277232},
	{-0.43394981,0.40631538,-0.80411154},
	{0.47543647,-0.80499518,-0.35488439},
	{8.7853237e-2,0.99329146,-7.5192261e-2},
	{1.0788139e-17,0.98465509,-0.17451175},
	{-0.48390044,0.84474655,-0.22856865},
	{-0.33258150,-0.13943530,-0.93270968},
	{0.13412798,0.32778620,-0.93518228},
	{0.40824829,-0.40824829,-0.81649658},
	{-0.56415183,-0.23652152,-0.79106908},
	{0.22866118,0.55880945,-0.79714871},
	{0.57735027,-0.57735027,-0.57735027},
	{-2.8025182e-17,-0.99960066,2.8258047e-2},
	{4.7262933e-3,-0.99593883,8.9908387e-2},
	{0.42617959,-0.79783632,0.42641314},
	{-0.43215555,-0.78199913,0.44913132},
	{-0.22799556,-0.88318102,-0.40988940},
	{0.59787346,-0.71460540,-0.36316174},
	{0.49281541,-0.58320993,0.64575472},
	{-0.62855906,-0.53374519,0.56571157},
	{-0.45196023,-0.66200343,-0.59789916},
	{0.71339149,-0.53241025,-0.45564449},
	{-0.15240249,-0.98634754,6.2385911e-2},
	{0.64426832,-0.76243338,6.0113849e-2},
	{0.22318617,-0.79194010,0.56834744},
	{-0.36561952,-0.91152525,-0.18826601},
	{0.78643270,-0.58738763,-0.19104809},
	{0.20327628,-0.71984664,0.66370142},
	{1.4066952e-16,0.94895546,-0.31541011},
	{-0.86124044,0.19354226,0.46990030},
	{-0.44128491,-0.82737129,0.34745414},
	{-0.44557832,0.86912575,-0.21466344},
	{-0.63746204,-0.60024095,-0.48306620},
	{-0.16603228,-0.97949042,0.11415690},
	{-0.44600548,-0.57602802,0.68503345},
	{-0.29943693,-0.95257435,5.4218418e-2},
	{-0.89151854,-0.40476382,0.20337389},
	{-0.75035097,0.65984450,3.9732434e-2},
	{-9.3572596e-2,0.98436917,-0.14920289},
	{-0.11567190,0.84839789,0.51656658},
	{-0.29313008,-0.46907267,0.83309398},
	{-7.8601701e-2,-0.97656991,-0.20033220},
	{-0.98438195,-0.17594065,-6.0886741e-3},
	{-0.92598531,0.37724245,1.5470437e-2},
	{8.6661463e-2,0.90634138,-0.41356389},
	{-0.11349856,0.64951800,0.75182741},
	{-0.47015925,0.50809691,-0.72165629},
	{7.9274763e-2,-0.46306430,-0.88277232},
	{0.43394981,0.40631538,-0.80411154},
	{-0.47543647,-0.80499518,-0.35488439},
	{-8.7853237e-2,0.99329146,-7.5192261e-2},
	{0.48390044,0.84474655,-0.22856865},
	{0.33258150,-0.13943530,-0.93270968},
	{-0.13412798,0.32778620,-0.93518228},
	{-0.40824829,-0.40824829,-0.81649658},
	{0.56415183,-0.23652152,-0.79106908},
	{-0.22866118,0.55880945,-0.79714871},
	{-0.57735027,-0.57735027,-0.57735027},
	{-4.7262933e-3,-0.99593883,8.9908387e-2},
	{-0.42617959,-0.79783632,0.42641314},
	{0.43215555,-0.78199913,0.44913132},
	{0.22799556,-0.88318102,-0.40988940},
	{-0.59787346,-0.71460540,-0.36316174},
	{-0.49281541,-0.58320993,0.64575472},
	{0.62855906,-0.53374519,0.56571157},
	{0.45196023,-0.66200343,-0.59789916},
	{-0.71339149,-0.53241025,-0.45564449},
	{0.15240249,-0.98634754,6.2385911e-2},
	{-0.64426832,-0.76243338,6.0113849e-2},
	{-0.22318617,-0.79194010,0.56834744},
	{0.36561952,-0.91152525,-0.18826601},
	{-0.78643270,-0.58738763,-0.19104809},
	{-0.20327628,-0.71984664,0.66370142},
};
//o cube1
material(mtl_plane1::m_hull);
glBegin(GL_POLYGON);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
	glNormal3fv(normals[90]);
	glVertex3fv(vertices[90]);
	glNormal3fv(normals[91]);
	glVertex3fv(vertices[91]);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
	glNormal3fv(normals[62]);
	glVertex3fv(vertices[62]);
	glNormal3fv(normals[60]);
	glVertex3fv(vertices[60]);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
	glNormal3fv(normals[92]);
	glVertex3fv(vertices[92]);
	glNormal3fv(normals[90]);
	glVertex3fv(vertices[90]);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
	glNormal3fv(normals[74]);
	glVertex3fv(vertices[74]);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
	glNormal3fv(normals[85]);
	glVertex3fv(vertices[85]);
	glNormal3fv(normals[82]);
	glVertex3fv(vertices[82]);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
	glNormal3fv(normals[61]);
	glVertex3fv(vertices[61]);
	glNormal3fv(normals[62]);
	glVertex3fv(vertices[62]);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
	glNormal3fv(normals[73]);
	glVertex3fv(vertices[73]);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
	glNormal3fv(normals[81]);
	glVertex3fv(vertices[81]);
	glNormal3fv(normals[72]);
	glVertex3fv(vertices[72]);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
	glNormal3fv(normals[82]);
	glVertex3fv(vertices[82]);
	glNormal3fv(normals[83]);
	glVertex3fv(vertices[83]);
	glNormal3fv(normals[81]);
	glVertex3fv(vertices[81]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
	glNormal3fv(normals[74]);
	glVertex3fv(vertices[74]);
	glNormal3fv(normals[73]);
	glVertex3fv(vertices[73]);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
	glNormal3fv(normals[59]);
	glVertex3fv(vertices[59]);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
	glNormal3fv(normals[60]);
	glVertex3fv(vertices[60]);
	glNormal3fv(normals[61]);
	glVertex3fv(vertices[61]);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
	glNormal3fv(normals[59]);
	glVertex3fv(vertices[59]);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
	glNormal3fv(normals[91]);
	glVertex3fv(vertices[91]);
	glNormal3fv(normals[92]);
	glVertex3fv(vertices[92]);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
	glNormal3fv(normals[72]);
	glVertex3fv(vertices[72]);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
	glNormal3fv(normals[73]);
	glVertex3fv(vertices[73]);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
	glNormal3fv(normals[72]);
	glVertex3fv(vertices[72]);
	glNormal3fv(normals[81]);
	glVertex3fv(vertices[81]);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
	glNormal3fv(normals[84]);
	glVertex3fv(vertices[84]);
	glNormal3fv(normals[85]);
	glVertex3fv(vertices[85]);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
	glNormal3fv(normals[72]);
	glVertex3fv(vertices[72]);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
	glNormal3fv(normals[73]);
	glVertex3fv(vertices[73]);
	glNormal3fv(normals[74]);
	glVertex3fv(vertices[74]);
	glNormal3fv(normals[71]);
	glVertex3fv(vertices[71]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
	glNormal3fv(normals[75]);
	glVertex3fv(vertices[75]);
	glNormal3fv(normals[76]);
	glVertex3fv(vertices[76]);
	glNormal3fv(normals[70]);
	glVertex3fv(vertices[70]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[70]);
	glVertex3fv(vertices[70]);
	glNormal3fv(normals[72]);
	glVertex3fv(vertices[72]);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[70]);
	glVertex3fv(vertices[70]);
	glNormal3fv(normals[76]);
	glVertex3fv(vertices[76]);
	glNormal3fv(normals[77]);
	glVertex3fv(vertices[77]);
	glNormal3fv(normals[71]);
	glVertex3fv(vertices[71]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[71]);
	glVertex3fv(vertices[71]);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
	glNormal3fv(normals[70]);
	glVertex3fv(vertices[70]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[71]);
	glVertex3fv(vertices[71]);
	glNormal3fv(normals[77]);
	glVertex3fv(vertices[77]);
	glNormal3fv(normals[75]);
	glVertex3fv(vertices[75]);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[72]);
	glVertex3fv(vertices[72]);
	glNormal3fv(normals[70]);
	glVertex3fv(vertices[70]);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[74]);
	glVertex3fv(vertices[74]);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
	glNormal3fv(normals[71]);
	glVertex3fv(vertices[71]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[75]);
	glVertex3fv(vertices[75]);
	glNormal3fv(normals[78]);
	glVertex3fv(vertices[78]);
	glNormal3fv(normals[79]);
	glVertex3fv(vertices[79]);
	glNormal3fv(normals[76]);
	glVertex3fv(vertices[76]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[76]);
	glVertex3fv(vertices[76]);
	glNormal3fv(normals[79]);
	glVertex3fv(vertices[79]);
	glNormal3fv(normals[80]);
	glVertex3fv(vertices[80]);
	glNormal3fv(normals[77]);
	glVertex3fv(vertices[77]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[77]);
	glVertex3fv(vertices[77]);
	glNormal3fv(normals[80]);
	glVertex3fv(vertices[80]);
	glNormal3fv(normals[78]);
	glVertex3fv(vertices[78]);
	glNormal3fv(normals[75]);
	glVertex3fv(vertices[75]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[78]);
	glVertex3fv(vertices[78]);
	glNormal3fv(normals[80]);
	glVertex3fv(vertices[80]);
	glNormal3fv(normals[79]);
	glVertex3fv(vertices[79]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[81]);
	glVertex3fv(vertices[81]);
	glNormal3fv(normals[83]);
	glVertex3fv(vertices[83]);
	glNormal3fv(normals[84]);
	glVertex3fv(vertices[84]);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[82]);
	glVertex3fv(vertices[82]);
	glNormal3fv(normals[86]);
	glVertex3fv(vertices[86]);
	glNormal3fv(normals[87]);
	glVertex3fv(vertices[87]);
	glNormal3fv(normals[83]);
	glVertex3fv(vertices[83]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[83]);
	glVertex3fv(vertices[83]);
	glNormal3fv(normals[87]);
	glVertex3fv(vertices[87]);
	glNormal3fv(normals[88]);
	glVertex3fv(vertices[88]);
	glNormal3fv(normals[84]);
	glVertex3fv(vertices[84]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[84]);
	glVertex3fv(vertices[84]);
	glNormal3fv(normals[88]);
	glVertex3fv(vertices[88]);
	glNormal3fv(normals[89]);
	glVertex3fv(vertices[89]);
	glNormal3fv(normals[85]);
	glVertex3fv(vertices[85]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[85]);
	glVertex3fv(vertices[85]);
	glNormal3fv(normals[89]);
	glVertex3fv(vertices[89]);
	glNormal3fv(normals[86]);
	glVertex3fv(vertices[86]);
	glNormal3fv(normals[82]);
	glVertex3fv(vertices[82]);
glEnd();
material(mtl_plane1::m_klappen);
glBegin(GL_POLYGON);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[86]);
	glVertex3fv(vertices[86]);
	glNormal3fv(normals[89]);
	glVertex3fv(vertices[89]);
	glNormal3fv(normals[88]);
	glVertex3fv(vertices[88]);
	glNormal3fv(normals[87]);
	glVertex3fv(vertices[87]);
glEnd();
material(mtl_plane1::m_windows);
glBegin(GL_POLYGON);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
	glNormal3fv(normals[16]);
	glVertex3fv(vertices[16]);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
	glNormal3fv(normals[16]);
	glVertex3fv(vertices[16]);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
	glNormal3fv(normals[16]);
	glVertex3fv(vertices[16]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
	glNormal3fv(normals[63]);
	glVertex3fv(vertices[63]);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
	glNormal3fv(normals[65]);
	glVertex3fv(vertices[65]);
	glNormal3fv(normals[59]);
	glVertex3fv(vertices[59]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[59]);
	glVertex3fv(vertices[59]);
	glNormal3fv(normals[65]);
	glVertex3fv(vertices[65]);
	glNormal3fv(normals[63]);
	glVertex3fv(vertices[63]);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[60]);
	glVertex3fv(vertices[60]);
	glNormal3fv(normals[66]);
	glVertex3fv(vertices[66]);
	glNormal3fv(normals[67]);
	glVertex3fv(vertices[67]);
	glNormal3fv(normals[61]);
	glVertex3fv(vertices[61]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[61]);
	glVertex3fv(vertices[61]);
	glNormal3fv(normals[67]);
	glVertex3fv(vertices[67]);
	glNormal3fv(normals[68]);
	glVertex3fv(vertices[68]);
	glNormal3fv(normals[62]);
	glVertex3fv(vertices[62]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[62]);
	glVertex3fv(vertices[62]);
	glNormal3fv(normals[68]);
	glVertex3fv(vertices[68]);
	glNormal3fv(normals[66]);
	glVertex3fv(vertices[66]);
	glNormal3fv(normals[60]);
	glVertex3fv(vertices[60]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[63]);
	glVertex3fv(vertices[63]);
	glNormal3fv(normals[65]);
	glVertex3fv(vertices[65]);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[66]);
	glVertex3fv(vertices[66]);
	glNormal3fv(normals[68]);
	glVertex3fv(vertices[68]);
	glNormal3fv(normals[67]);
	glVertex3fv(vertices[67]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[90]);
	glVertex3fv(vertices[90]);
	glNormal3fv(normals[93]);
	glVertex3fv(vertices[93]);
	glNormal3fv(normals[94]);
	glVertex3fv(vertices[94]);
	glNormal3fv(normals[91]);
	glVertex3fv(vertices[91]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[91]);
	glVertex3fv(vertices[91]);
	glNormal3fv(normals[94]);
	glVertex3fv(vertices[94]);
	glNormal3fv(normals[95]);
	glVertex3fv(vertices[95]);
	glNormal3fv(normals[92]);
	glVertex3fv(vertices[92]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[92]);
	glVertex3fv(vertices[92]);
	glNormal3fv(normals[95]);
	glVertex3fv(vertices[95]);
	glNormal3fv(normals[93]);
	glVertex3fv(vertices[93]);
	glNormal3fv(normals[90]);
	glVertex3fv(vertices[90]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[93]);
	glVertex3fv(vertices[93]);
	glNormal3fv(normals[95]);
	glVertex3fv(vertices[95]);
	glNormal3fv(normals[94]);
	glVertex3fv(vertices[94]);
glEnd();
}
} //namespace
