#include <stdio.h>
#include <stdlib.h>
#include <colorblind.h>
#include "_test.h"

void test_color(COLORBLIND_RUNTIME* runtime,
                int colorred, int colorgreen, int colorblue,
                int touch,
                int resultred, int resultgreen, int resultblue);

int main(int argc, char** argv) {
        printf("1..77\n");
        COLORBLIND_RUNTIME* runtime = colorblind_create();
        ok(runtime != NULL,"colorblind_create returns a valid pointer");

        ok(colorblind_set_filter_type(runtime,colorblind_filter_t_selective_saturate_red)==0,"Setting the filter");

        test_color(runtime, 255,0  ,0    ,0,  255,0  ,0  );
        test_color(runtime, 50 ,87 ,10   ,1,  255,87 ,10 );
        test_color(runtime, 90 ,0  ,90   ,1,  255,0  ,90 );
        test_color(runtime, 255,80 ,80   ,0,  255,80 ,80 );
        test_color(runtime, 20 ,80 ,80   ,0,  20 ,80 ,80 );
        test_color(runtime, 255,125,0    ,1,  255,125,0  );
        test_color(runtime, 160,80 ,0    ,1,  255,80 ,0  );
        test_color(runtime, 0  ,125,255  ,0,  0  ,125,255);
        test_color(runtime, 100,100,100  ,0,  100,100,100);
        test_color(runtime, 80 ,0  ,80   ,1,  255,0  ,80 );
        test_color(runtime, 40 ,40 ,255  ,0,  40 ,40 ,255);
        test_color(runtime, 0  ,0  ,0    ,0,  0  ,0  ,0  );


        ok(colorblind_set_filter_type(runtime,colorblind_filter_t_selective_saturate_green)==0,"Setting the filter");

        test_color(runtime, 0  ,255,0    ,0,  0  ,255,0  );
        test_color(runtime, 87 ,50 ,10   ,1,  87 ,255,10 );
        test_color(runtime, 0  ,90 ,90   ,1,  0  ,255,90 );
        test_color(runtime, 80 ,255,80   ,0,  80 ,255,80 );
        test_color(runtime, 80 ,20 ,80   ,0,  80 ,20 ,80 );
        test_color(runtime, 125,255,0    ,1,  125,255,0  );
        test_color(runtime, 80 ,160,0    ,1,  80 ,255,0  );
        test_color(runtime, 125,0  ,255  ,0,  125,0  ,255);
        test_color(runtime, 100,100,100  ,0,  100,100,100);
        test_color(runtime, 0  ,80 ,80   ,1,  0  ,255,80 );
        test_color(runtime, 40 ,40 ,255  ,0,  40 ,40 ,255);
        test_color(runtime, 0  ,0  ,0    ,0,  0  ,0  ,0  );


        ok(colorblind_set_filter_type(runtime,colorblind_filter_t_selective_saturate_blue)==0,"Setting the filter");

        test_color(runtime, 0  ,0  ,255  ,0,  0  ,0  ,255);
        test_color(runtime, 87 ,10 ,50   ,1,  87 ,10 ,255);
        test_color(runtime, 0  ,90 ,90   ,1,  0  ,90 ,255);
        test_color(runtime, 80 ,80 ,255  ,0,  80 ,80 ,255);
        test_color(runtime, 80 ,80 ,20   ,0,  80 ,80 ,20 );
        test_color(runtime, 125,0  ,255  ,1,  125,0  ,255);
        test_color(runtime, 80 ,0  ,160  ,1,  80 ,0  ,255);
        test_color(runtime, 125,255,0    ,0,  125,255,0  );
        test_color(runtime, 100,100,100  ,0,  100,100,100);
        test_color(runtime, 0  ,80 ,80   ,1,  0  ,80 ,255);
        test_color(runtime, 40 ,255,40   ,0,  40 ,255,40 );
        test_color(runtime, 0  ,0  ,0    ,0,  0  ,0  ,0  );

        colorblind_destroy(runtime);
        ok(1,"destroyed");
        return 0;
}
