.TH "afetch" 1 "Oct 2002" "SQUID 1.9g" "SQUID Manual"

.SH NAME
.TP 
afetch - retrieve an alignment from an alignment database 

.SH SYNOPSIS
.B afetch
.I [options]
.I alignmentdb
.I key

.PP
.B afetch --index
.I alignmentdb

.SH DESCRIPTION

.B afetch
retrieves the alignment named
.I key
from an alignment database in file
.I alignmentdb.

.PP 
.I alignmentdb 
is a "multiple multiple alignment" file in Stockholm (e.g. native
Pfam) format.

.PP
.I key 
is either the name (ID) of the alignment, or its accession
number (AC).

.PP
The 
.I alignmentdb
file should first be SSI indexed with
.B afetch --index
for efficient retrieval. An SSI index is
not required, but alignment retrieval without one may
be painfully slow.

.SH OPTIONS

.TP
.B -h
Print brief help; includes version number and summary of
all options, including expert options.

.SH EXPERT OPTIONS

.TP
.B --index
Instead of retrieving a
.I key,
the special command
.B afetch --index
.I alignmentdb
produces an SSI index of the names and accessions
of the alignments in 
the file 
.I alignmentdb. 
This should be run once on the 
.I alignmentdb
file to prepare it for all future afetch's.

.SH SEE ALSO

.PP
Master man page, with full list of and guide to the
individual man pages for SQUID's auxiliary programs: see
.B squid(1).

.SH AUTHOR

SQUID and its documentation are Copyright (C) 1992-2002 HHMI/Washington University School of Medicine
Freely distributed under the GNU General Public License (GPL)
See COPYING in the source code distribution for more details, or contact me.

.nf
Sean Eddy
Dept. of Genetics
Washington Univ. School of Medicine
4566 Scott Ave.
St Louis, MO 63110 USA
Phone: 1-314-362-7666
FAX  : 1-314-362-7855
Email: eddy@genetics.wustl.edu
.fi


