// Copyright 2015 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_CHROMEOS_CERTIFICATE_PROVIDER_CERTIFICATE_PROVIDER_H_
#define CHROME_BROWSER_CHROMEOS_CERTIFICATE_PROVIDER_CERTIFICATE_PROVIDER_H_

#include <vector>

#include "base/macros.h"
#include "base/memory/ref_counted.h"
#include "net/cert/x509_certificate.h"

namespace chromeos {

class CertificateProvider {
 public:
  CertificateProvider() {}
  virtual ~CertificateProvider() {}

  virtual void GetCertificates(
      const base::Callback<void(const net::CertificateList&)>& callback) = 0;

  virtual scoped_ptr<CertificateProvider> Copy() = 0;

 private:
  DISALLOW_COPY_AND_ASSIGN(CertificateProvider);
};

}  // namespace chromeos

#endif  // CHROME_BROWSER_CHROMEOS_CERTIFICATE_PROVIDER_CERTIFICATE_PROVIDER_H_
