(declare (unit precsi))
(declare (uses example))

;; display prelude to csi
(display "constants\n\n")

(display "  A SWIG example for the CHICKEN compiler\n")
(display "  Author: Jonah Beckford, December 2002\n\n")

(display "C Procedures:\n")
(display "  #define    ICONST      42\n")
(display "  #define    FCONST      2.1828\n")
(display "  #define    CCONST      'x'\n")
(display "  #define    CCONST2     '\n'\n")
(display "  #define    SCONST      \"Hello World\"\n")
(display "  #define    SCONST2     \"\\\"Hello World\\\"\"\n")
(display "  /* This should work just fine */\n")
(display "  #define    EXPR        ICONST + 3*(FCONST)\n")
(display "  /* This shouldn't do anything */\n")
(display "  #define    EXTERN      extern\n")
(display "  /* Neither should this (BAR isn't defined) */\n")
(display "  #define    FOO         (ICONST + BAR)\n")
(display "  /* The following directives also produce constants.  Remember that\n")
(display "     CHICKEN is normally case-insensitive, so don't rely on differing\n")
(display "     case to differentiate variable names */\n")
(display "  %constant int iconstX = 37;\n")
(display "  %constant double fconstX = 3.14;\n")
(display "\n")

(display "Scheme Procedures:\n")
(display "  (example:ICONST)\n")
(display "  (example:FCONST)\n")
(display "  (example:CCONST)\n")
(display "  (example:CCONST2)\n")
(display "  (example:SCONST)\n")
(display "  (example:SCONST2)\n")
(display "  (example:EXPR)\n")
(display "  (example:EXTERN)\n")
(display "  (example:FOO)\n")
(display "  (example:iconstX)\n")
(display "  (example:fconstX)\n")
(display "\n")
