# -*- coding: utf-8 -*-

# Bluemindo: A really simple but powerful audio player in Python/PyGTK.
# Copyright (C) 2007-2009  Erwan Briand

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 3 of the License.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from gtk.glade import XML as glade_XML
from ConfigParser import ConfigParser, DuplicateSectionError
from os.path import join
from os import getcwd

class Config:
    def __init__(self, module, lcdown, config_file, get_configuration):
        self.module = module
        self.lcdown = lcdown
        self.config_file = config_file
        self.get_configuration = get_configuration

    def save_config(self, name):
        if name == self.module['name']:
            check_active = self.conf_widgets.get_widget('checkbutton1')
            combo_server = self.conf_widgets.get_widget('combobox1')

            active = check_active.get_active()
            server = combo_server.get_model()[combo_server.get_active()][0]

            configparser = ConfigParser()
            configparser.read(self.config_file)

            try:
                configparser.add_section(self.module['name'])
            except DuplicateSectionError:
                pass

            configparser.set(self.module['name'], 'active', int(active))
            configparser.set(self.module['name'], 'server', server)

            configparser.write(open(self.config_file, 'w'))
            self.lcdown.reload_config(self.get_configuration())

    def configuration(self, args):
        (name, widgets) = args
        if name == self.module['name']:
            # Load the glade and put the vertical box in the module's
            # configuration one
            config = self.get_configuration()

            self.conf_widgets = glade_XML(join(getcwd(), 'modules',
                                          'lyrics', 'configuration.glade'),
                                          'vbox1', domain='bluemindo')

            hbox = widgets.get_widget('hbox1')

            try:
                kids = hbox.get_children()
                hbox.remove(kids[2])
            except:
                pass

            hbox.add(self.conf_widgets.get_widget('vbox1'))

            check_popup = self.conf_widgets.get_widget('checkbutton1')
            if config['active']:
                check_popup.set_active(True)

            combo = self.conf_widgets.get_widget('combobox1')
            if config['server'] == 'lyricwiki.org':
                combo.set_active(0)
            elif config['server'] == 'lyrc.com.ar':
                combo.set_active(1)
            elif config['server'] == 'lyriki.com':
                combo.set_active(2)