// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __AllocChecker_h__
#define __AllocChecker_h__

#include <iostream>
#include <map>
using namespace std;

namespace Puma {


template <class T>
class AllocChecker {
  enum AllocState { ALLOC_NEW, ALLOC_FREE };
  typedef map<T*, AllocState> Map;
  typedef typename Map::value_type MapPair;
  Map _map;

public:
  void alloc (T* obj) {
    typename Map::iterator entry = _map.find (obj);
    if (entry != _map.end ()) {
      if ((*entry).second == ALLOC_NEW) {
        cout << (*entry).first << " allocated twice" << endl;
      }
      (*entry).second = ALLOC_NEW;
    } else {
      _map.insert (MapPair (obj, ALLOC_NEW));
    }
  }

  void release (T* obj) {
    typename Map::iterator entry = _map.find (obj);
    if (entry != _map.end ()) {
      if ((*entry).second == ALLOC_NEW) {
        (*entry).second = ALLOC_FREE;
      } else {
        cout << (*entry).first << " freed twice" << endl;
      }
    } else {
      cout << (*entry).first << " freed but never allocated" << endl;
    }
  }
};


} // namespace Puma

#endif /* __AllocChecker_h__ */
