The Oracle Cloud Infrastructure (OCI) DNS service lets you
[create and manage public and private DNS zones][DNS] in an OCI tenancy.
The DNS Service provides each tenancy with a limit of 1,000 zones and 25,000
records per zone and is [charged per 1M queries][COST].

Before you can use OCI DNS with `acme.sh`, you'll need  the following:

* A private [API signing key][APIKEY]; and
* The [tenancy and service account OCIDs][OCIDS]

We recommend [installing the OCI CLI][CLI] and using the [interactive setup process][CSTP]
to create an API signing keypair. If the OCI CLI is configured, the plugin will automatically
detect and use the configuration file for authentication. 

Alternatively, the [OCI Developer Guide][DG] provides the manual steps required
to generate the API signing keys and determine the required OCIDs.

## Configuration

### Automatic configuration

**No configuration is required** if an [OCI CLI][CLI] configuraton file is
located at `$HOME/.oci/config` and has a `DEFAULT` profile that can be used to manage
DNS records in the target tenancy.

To override the configuration file path or profile name, set the following environment
variables:

* `OCI_CLI_CONFIG_FILE`: set to the full path including filename of the OCI SDK and CLI 
  configuration file. 
* `OCI_CLI_PROFILE`: provide an existing profile from the configuration file. Case-sensitive!

### Manual configuration

If the OCI CLI is not installed, the following environment variables must be set:

* `OCI_CLI_USER`: OCID of the user calling the API. Example: `ocid1.user.oc1..<unique_ID>`
* `OCI_CLI_TENANCY`: OCID of your tenancy. Example: `ocid1.tenancy.oc1..<unique_ID>`
* `OCI_CLI_REGION`: Your Oracle Cloud Infrastructure home region.

You also need to provide the API signing key using one of the
following two variables:

* `OCI_CLI_KEY_FILE`: Path to the file containing the private API signing key
  in PEM format; or
* `OCI_CLI_KEY`: the private API signing key in PEM format

> **Tip:** The variables above can also be used to override the values stored in the 
> OCI SDK and CLI configuration file.

### Issuing a certificate

To issue a certificate, ensure either the OCI CLI is working correctly or all
the mandatory environment variables have been configured, then run:

```shell
acme.sh --issue --dns dns_oci -d example.com -d www.example.com
```

To issue a wildcard certificate, use::

```shell
acme.sh --issue --dns dns_oci -d example.com -d *.example.com
```

## Required IAM service policy

Permissions are required to add and remove DNS records from DNS. Ensure that 
a policy exists that grants the specified user sufficient permission to create 
and remove `TXT` records in the target zone(s) in the tenancy.

Here is an example policy that grants all DNS operations in all zones in the 
tenancy for all members of a specific user group: 

```
Allow group <GroupName> to manage dns in tenancy <TenancyName>
```

If you're new to policies, see [Getting Started with Policies][POLS] and [Common Policies][CPOLS]. 
For more details about policies for DNS, see [Details for the DNS Service][DNSPOL].

## Security recommendations

The **[Oracle Cloud Infrastructure Security Guide][OSG]** details the recommended
**[best practices for securing user authentication][BP]** which include:

* creating **a dedicated service user account** specifically for GitHub Actions;
* assigning that service account a **unique** and **complex** password;
* **rotating the API signing key pair** used by the service account every 90 days; and
* using **[GitHub encrypted secrets][GHS]** to store credentials.

## Reporting an issue

Please use <https://github.com/acmesh-official/acme.sh/issues/3540> to report
any issues or bugs.

[DNS]: https://docs.oracle.com/en-us/iaas/Content/DNS/Tasks/managingdnszones.htm#Managing_DNS_Service_Zones
[COST]: https://www.oracle.com/cloud/price-list.html#dns
[DG]: https://docs.oracle.com/en-us/iaas/Content/API/Concepts/devtoolslanding.htm
[APIKEY]: https://docs.oracle.com/en-us/iaas/Content/API/Concepts/apisigningkey.htm
[OCIDS]: https://docs.oracle.com/en-us/iaas/Content/API/Concepts/apisigningkey.htm#five
[CLI]: https://docs.oracle.com/en-us/iaas/Content/API/Concepts/cliconcepts.htm
[CSTP]:https://docs.oracle.com/en-us/iaas/Content/API/SDKDocs/cliinstall.htm#configfile
[OSG]: https://docs.oracle.com/en-us/iaas/Content/Security/Concepts/security_guide.htm
[BP]:  https://docs.oracle.com/en-us/iaas/Content/Security/Reference/iam_security.htm
[GHS]: https://docs.github.com/en/actions/reference/encrypted-secrets
[REGS]: https://docs.oracle.com/en-us/iaas/Content/General/Concepts/regions.htm#top
[CLIVARS]: https://docs.oracle.com/en-us/iaas/Content/API/SDKDocs/clienvironmentvariables.htm
[IAM]: https://docs.oracle.com/en-us/iaas/Content/DNS/Concepts/dnszonemanagement.htm#Required_IAM_Service_Policy
[POLS]: https://docs.oracle.com/en-us/iaas/Content/Identity/Concepts/policygetstarted.htm#Getting_Started_with_Policies
[CPOLS]: https://docs.oracle.com/en-us/iaas/Content/Identity/Concepts/commonpolicies.htm#top
[DNSPOL]: https://docs.oracle.com/en-us/iaas/Content/Identity/Reference/dnspolicyreference.htm#Details_for_the_DNS_Service