;; sdic-gene.el ---- -*- Emacs-Lisp -*- Library to search COMPAT format dictionary.
;; $Id: sdic-gene.el,v 2.6 2002/07/02 11:17:46 tsuchiya Exp $

;; Copyright (C) 1998,99 TSUCHIYA Masatoshi <tsuchiya@namazu.org>

;; Author: TSUCHIYA Masatoshi <tsuchiya@namazu.org>
;; Keywords: dictionary

;; This file is part of SDIC.

;; SDIC is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.

;; SDIC is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SDIC; if not, write to the Free Software Foundation,
;; Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


;;; Commentary:

;; This file is a part of sdic. Please see sdic.el for more detail.

;; COMPAT μץ餺˸饤֥Ǥ
;; COMPAT ξܺ٤ˤĤƤ sdic.texi 򻲾ȤƲ


;;; Install:

;; (1) ŬڤʷѴơŬʾ( : /usr/dict/ )¸
;;     ƲѴѥץȤȤưʲ Perl ץȤ
;;     ѤǤޤ
;;
;;         gene.perl    - GENE95 
;;         jgene.perl   - GENE95 񤫤±Ѽ
;;         eijirou.perl - ѼϺ
;;
;; (2) Ȥ褦ˤ sdic-eiwa-dictionary-list ޤ
;;      sdic-waei-dictionary-list ɲäƲ
;;
;;         (setq sdic-eiwa-dictionary-list
;;               (cons '(sdic-gene "/usr/dict/gene.dic") sdic-eiwa-dictionary-list))
;;
;;     ϼΤ褦ʹˤʤäƤޤ
;;
;;         (sdic-gene ե̾ (ץA A) (ץB B) ...)
;;
;;     ̤ʻ꤬פʾˤϡץϾάǤޤ
;;
;;         (sdic-gene ե̾)


;;; Options:

;; sdic-gene.el ФƻǤ륪ץϼ̤Ǥ
;;
;; coding-system
;;     δɤꤷޤάϡ
;;     sdic-default-coding-system ͤȤޤ
;;
;; title
;;     Υȥꤷޤάϡե 
;;     basename 򥿥ȥȤޤ
;;
;; extract
;;     ̼Ÿ뤿γޥɤꤷޤά
;;     ϡ񤬰̤Ƥʤȸʤޤ
;;
;; extract-option
;;     extract ץˤäƻꤵ줿ޥɤФơ
;;     ŸɸϤ˽Ϥ뤿Υޥɥ饤ꤷ
;;     ޤά sdic-gene-extract-option ͤȤޤ


;;; Note:

;; sdic-compat.el  sdic-gene.el Ʊǽ󶡤Ƥ饤֥
;; sdic-compat.el ϳޥɤƤӽФƤΤФơ
;; sdic-gene.el  Emacs εǽΤߤѤƤޤХ
;; եɤ߹Ǥ鸡ԤʤΤǡ̤Υ꤬ɬפˤʤޤ
;;
;; Default ǤϡɬפʳޥɤĤä 
;; sdic-compat.el 򡢸Ĥʤäˤ sdic-gene.el Ȥ褦
;; ˤʤäƤޤ


;;; 饤֥
(require 'sdic)
(require 'sdicf)
(provide 'sdic-gene)
(put 'sdic-gene 'version "2.0")
(put 'sdic-gene 'init-dictionary 'sdic-gene-init-dictionary)
(put 'sdic-gene 'open-dictionary 'sdic-gene-open-dictionary)
(put 'sdic-gene 'close-dictionary 'sdic-gene-close-dictionary)
(put 'sdic-gene 'search-entry 'sdic-gene-search-entry)
(put 'sdic-gene 'get-content 'sdic-gene-get-content)


;;;----------------------------------------------------------------------
;;;		/ѿ
;;;----------------------------------------------------------------------

(defvar sdic-gene-extract-option "-dc" "\
*Option for archiver.
̼Ÿ뤿˻Ȥץ")

(defconst sdic-gene-search-buffer-name " *sdic-gene*")



;;;----------------------------------------------------------------------
;;;		
;;;----------------------------------------------------------------------

(defun sdic-gene-init-dictionary (file-name &rest option-list)
  "Function to initialize dictionary"
  (let ((dic (sdic-make-dictionary-symbol)))
    (if (file-readable-p (setq file-name (expand-file-name file-name)))
	(progn
	  (mapcar '(lambda (c) (put dic (car c) (nth 1 c))) option-list)
	  (put dic 'file-name file-name)
	  (put dic 'identifier (concat "sdic-gene+" file-name))
	  (or (get dic 'title)
	      (put dic 'title (file-name-nondirectory file-name)))
	  (if (get dic 'extract)
	      (or (get dic 'extract-option)
		  (put dic 'extract-option sdic-gene-extract-option)))
	  (or (get dic 'coding-system)
	      (put dic 'coding-system sdic-default-coding-system))
	  dic)
      (error "Can't read dictionary: %s" (prin1-to-string file-name)))))


(defun sdic-gene-open-dictionary (dic)
  "Function to open dictionary"
  (if (or (sdicf-buffer-live-p (get dic 'sdic-gene-search-buffer))
	  (save-excursion
	    (set-buffer (put dic 'sdic-gene-search-buffer (generate-new-buffer sdic-gene-search-buffer-name)))
	    (buffer-disable-undo)
	    (insert "\n")
	    (prog1 (if (get dic 'extract)
		       (= 0 (sdicf-call-process (get dic 'extract) (get dic 'coding-system) nil t nil
						(get dic 'extract-option)
						(get dic 'file-name)))
		     (condition-case err
			 (sdicf-insert-file-contents (get dic 'file-name) (get dic 'coding-system))
		       (error nil)))
	      (setq buffer-read-only t)
	      (set-buffer-modified-p nil))))
      dic))


(defun sdic-gene-close-dictionary (dic)
  "Function to close dictionary"
  (kill-buffer (get dic 'sdic-gene-search-buffer))
  (put dic 'sdic-gene-search-buffer nil))


(defsubst sdic-gene-search-internal (string)
  "̾θԤؿ"
  (let (ret (case-fold-search t))
    (while (search-forward string nil t)
      (save-excursion
	(setq ret (cons (cons (buffer-substring (progn (beginning-of-line) (point))
						(progn (skip-chars-forward "^\t") (point)))
			      (1+ (point)))
			ret))))
    (nreverse ret)))


(defsubst sdic-gene-re-search-internal (string)
  "ɽԤؿ"
  (let (ret (case-fold-search t))
    (while (re-search-forward string nil t)
      (save-excursion
	(setq ret (cons (cons (buffer-substring (progn (beginning-of-line) (point))
						(progn (skip-chars-forward "^\t") (point)))
			      (1+ (point)))
			ret))))
    (nreverse ret)))


(defun sdic-gene-search-entry (dic string &optional search-type) "\
Function to search word with look or grep, and write results to current buffer.
search-type ͤˤäƼΤ褦ưѹ롣
    nil    : ׸
    t      : ׸
    lambda : ׸
    0      : ʸ
    regexp : ɽ
̤ȤƸĤäФ򥭡ȤʸƬ point ͤȤ
Ϣ֤
"
  (save-excursion
    (set-buffer (get dic 'sdic-gene-search-buffer))
    (goto-char (point-min))
    (cond
     ;; ׸
     ((eq search-type nil)
      (sdic-gene-search-internal (concat "\n" string)))
     ;; ׸
     ((eq search-type t)
      (sdic-gene-search-internal (concat string "\t")))
     ;; ׸
     ((eq search-type 'lambda)
      (sdic-gene-search-internal (concat "\n" string "\t")))
     ;; ʸ
     ((eq search-type 0)
      (sdic-gene-search-internal string))
     ;; ɽ
     ((eq search-type 'regexp)
      (sdic-gene-re-search-internal string))
     ;; ʳθꤵ줿
     (t (error "Not supported search type is specified. \(%s\)"
	       (prin1-to-string search-type))))))


(defun sdic-gene-get-content (dic point)
  (save-excursion
    (set-buffer (get dic 'sdic-gene-search-buffer))
    (if (<= point (point-max))
	(buffer-substring (goto-char point) (progn (end-of-line) (point)))
      (error "Can't find content. (ID=%d)" point))))
