#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Unmechanical
# send your bug reports to contact@dotslashplay.it
###

script_version=20221210.3

GAME_ID='unmechanical'
GAME_NAME='Unmechanical'

ARCHIVE_BASE_1='gog_unmechanical_2.1.0.5.sh'
ARCHIVE_BASE_1_MD5='a99865ecd58e895334d405523a23eee3'
ARCHIVE_BASE_1_TYPE='mojosetup'
ARCHIVE_BASE_1_SIZE='1600000'
ARCHIVE_BASE_1_VERSION='2.0-gog2.1.0.5'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/unmechanical'

ARCHIVE_BASE_0='gog_unmechanical_2.1.0.4.sh'
ARCHIVE_BASE_0_MD5='44453abb32e21b94e9731938486c71f7'
ARCHIVE_BASE_0_TYPE='mojosetup'
ARCHIVE_BASE_0_SIZE='1600000'
ARCHIVE_BASE_0_VERSION='2.0-gog2.1.0.4'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_BIN_FILES='
Engine
Binaries/Linux/UDKGame-Linux'
CONTENT_LIBS_BIN_PATH='data/noarch/game/Binaries/Linux/lib'
CONTENT_LIBS_BIN_FILES='
libPhysXCore.so
libPhysXExtensions.so.1
libPhysXLoader.so.1
libPhysXCooking.so
libSDL2_mixer-2.0.so.0
libtcmalloc.so.0
libsteam_api.so'
CONTENT_GAME_DATA_FILES='
UDKGame
UnmechanicalIcon.bmp'

APP_MAIN_EXE='Binaries/Linux/UDKGame-Linux'
APP_MAIN_ICON='UnmechanicalIcon.bmp'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
ld-linux.so.2
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libm.so.6
libogg.so.0
libopenal.so.1
libpthread.so.0
librt.so.1
libSDL2-2.0.so.0
libstdc++.so.6
libvorbisfile.so.3
libvorbis.so.0'

# Run the game binary from its parent directory

APP_MAIN_PRERUN="$APP_MAIN_PRERUN"'
# Run the game binary from its parent directory
cd "$(dirname "$APP_EXE")"
APP_EXE=$(basename "$APP_EXE")'

# Load common functions

target_version='2.19'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build package

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
