#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Lilly Looking Through
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220701.1

GAME_ID='lilly-looking-through'
GAME_NAME='Lilly Looking Through'

ARCHIVE_BASE_0='setup_lilly_looking_through_1.1.50_(21178).exe'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_MD5='a3318d6a5a5abfe946293c9e745f1fd9'
ARCHIVE_BASE_0_SIZE='400000'
ARCHIVE_BASE_0_VERSION='1.1.50-gog21178'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/lilly_looking_through'

CONTENT_PATH_DEFAULT='.'
ARCHIVE_GAME_BIN_FILES='
adobe?air
lillylookingthrough.exe
lilly.swf'
ARCHIVE_GAME_DATA_FILES='
meta-inf
mimetype
pkmedia'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE='lillylookingthrough.exe'
APP_MAIN_ICON='app/goggame-1207659903.ico'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID wine"

# icotool is used for icon .ico → .png conversion

SCRIPT_DEPS="$SCRIPT_DEPS icotool"

# Load common functions

target_version='2.16'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Work around "insufficient image data" issue with convert from imagemagick

icon_extract_png_from_ico() {
	local source_file destination_directory
	source_file="$1"
	destination_directory="$2"
	icotool --extract --output="$destination_directory" "$source_file" 2>/dev/null
}

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Include game icon

PKG='PKG_DATA'
icons_get_from_workdir 'APP_MAIN'

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
