/*
 * Decompiled with CFR 0.152.
 */
package com.highcharts.export.pool;

import com.highcharts.export.pool.AbstractPool;
import com.highcharts.export.pool.ObjectFactory;
import com.highcharts.export.pool.PoolException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class BlockingQueuePool<T>
extends AbstractPool<T> {
    LinkedBlockingQueue<T> linkQueue;

    public BlockingQueuePool(ObjectFactory<T> factory, int number, int maxWait, long retentionTime) throws PoolException {
        super(factory, number, maxWait, retentionTime);
        this.queue = new LinkedBlockingQueue();
        this.linkQueue = (LinkedBlockingQueue)this.queue;
    }

    @Override
    public T borrowObject() throws InterruptedException, PoolException {
        T object = this.linkQueue.poll(this.maxWait, TimeUnit.MILLISECONDS);
        if (object == null) {
            throw new PoolException();
        }
        this.poolSize.getAndDecrement();
        return object;
    }

    @Override
    public void returnObject(T object, boolean validate) throws InterruptedException {
        boolean valid;
        if (object == null) {
            return;
        }
        boolean bl = valid = !validate || this.objectFactory.validate(object);
        if (!valid) {
            this.destroyObject(object);
        } else {
            this.objectFactory.passivate(object);
            this.linkQueue.offer(object, this.maxWait, TimeUnit.MILLISECONDS);
            this.poolSize.incrementAndGet();
        }
    }
}

