/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MainOrTile;
import edu.harvard.hul.ois.jhove.module.jpeg2000.Tile;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class Codestream
extends MainOrTile {
    private NisoImageMetadata _niso;
    private List _tiles;
    private List _ppmLengthList;
    private Property _labelProperty;
    private Property _compMapProperty;
    private Property _sizProperty;
    private Property _crgProperty;
    private Property _paletteProperty;
    private Property _roiProperty;
    private List tileLengthList;

    public Codestream() {
        this._precSize = null;
        this._niso = new NisoImageMetadata();
    }

    public Property makeProperty() {
        Object object;
        ArrayList<Object> arrayList;
        ArrayList<Property> arrayList2 = new ArrayList<Property>(10);
        if (this._labelProperty != null) {
            arrayList2.add(this._labelProperty);
        }
        if (this._compMapProperty != null) {
            arrayList2.add(this._compMapProperty);
        }
        if (this._paletteProperty != null) {
            arrayList2.add(this._paletteProperty);
        }
        if (this._roiProperty != null) {
            arrayList2.add(this._roiProperty);
        }
        if (this._sizProperty != null) {
            arrayList2.add(this._sizProperty);
        }
        if (this._codProperty != null) {
            arrayList2.add(this._codProperty);
        }
        if (this._qcdProperty != null) {
            arrayList2.add(this._qcdProperty);
        }
        if (this._pocProperty != null) {
            arrayList2.add(this._pocProperty);
        }
        if (this.tileLengthList != null && !this.tileLengthList.isEmpty()) {
            arrayList2.add(new Property("TileLengths", PropertyType.PROPERTY, PropertyArity.LIST, this.tileLengthList));
        }
        if (this._packetLengthList != null && !this._packetLengthList.isEmpty()) {
            arrayList2.add(new Property("PacketLengths", PropertyType.LONG, PropertyArity.LIST, this._packetLengthList));
        }
        if (this._ppmLengthList != null && !this._ppmLengthList.isEmpty()) {
            arrayList2.add(new Property("PackedPacketHeaderLengths", PropertyType.LONG, PropertyArity.LIST, this._ppmLengthList));
        }
        if (this._crgProperty != null) {
            arrayList2.add(this._crgProperty);
        }
        arrayList2.add(new Property("NisoImageMetadata", PropertyType.NISOIMAGEMETADATA, this._niso));
        if (this._tiles != null && !this._tiles.isEmpty()) {
            arrayList = new ArrayList<Object>(this._tiles.size());
            ListIterator listIterator = this._tiles.listIterator();
            while (listIterator.hasNext()) {
                object = (Tile)listIterator.next();
                arrayList.add(((Tile)object).makeProperty());
            }
            arrayList2.add(new Property("Tiles", PropertyType.PROPERTY, PropertyArity.LIST, arrayList));
        }
        if (!this._comments.isEmpty()) {
            arrayList2.add(new Property("Comments", PropertyType.PROPERTY, PropertyArity.LIST, this._comments));
        }
        if (this._components != null) {
            arrayList = new ArrayList(this._components.length);
            for (int i = 0; i < this._components.length; ++i) {
                object = this._components[i];
                if (object == null) continue;
                arrayList.add(object);
            }
            if (!arrayList.isEmpty()) {
                arrayList2.add(new Property("Components", PropertyType.PROPERTY, PropertyArity.LIST, arrayList));
            }
        }
        return new Property("Codestream", PropertyType.PROPERTY, PropertyArity.LIST, arrayList2);
    }

    public void setDefaultNiso(NisoImageMetadata nisoImageMetadata) {
        this._niso.setByteOrder(nisoImageMetadata.getByteOrder());
        this._niso.setMimeType(nisoImageMetadata.getMimeType());
        this._niso.setBitsPerSample(nisoImageMetadata.getBitsPerSample());
        this._niso.setImageLength(nisoImageMetadata.getImageLength());
        this._niso.setImageWidth(nisoImageMetadata.getImageWidth());
        this._niso.setSamplesPerPixel(nisoImageMetadata.getSamplesPerPixel());
        this._niso.setCompressionScheme(nisoImageMetadata.getCompressionScheme());
        this._niso.setYSamplingFrequency(nisoImageMetadata.getYSamplingFrequency());
        this._niso.setXSamplingFrequency(nisoImageMetadata.getXSamplingFrequency());
        this._niso.setSamplingFrequencyUnit(nisoImageMetadata.getSamplingFrequencyUnit());
    }

    public NisoImageMetadata getNiso() {
        return this._niso;
    }

    public void setTiles(List list) {
        this._tiles = list;
    }

    public void addTileLength(Property property) {
        if (this.tileLengthList == null) {
            this.tileLengthList = new LinkedList();
        }
        this.tileLengthList.add(property);
    }

    public void addPPMLength(long l) {
        this._ppmLengthList.add(new Long(l));
    }

    protected void setLabelProperty(Property property) {
        this._labelProperty = property;
    }

    protected void setCompMapProperty(Property property) {
        this._compMapProperty = property;
    }

    protected void setPaletteProperty(Property property) {
        this._paletteProperty = property;
    }

    protected void setROIProperty(Property property) {
        this._roiProperty = property;
    }

    protected void setSIZProperty(Property property) {
        this._sizProperty = property;
    }

    protected void setCRGProperty(Property property) {
        this._crgProperty = property;
    }

    @Override
    public void setCompProperty(int n, Property property) {
        if (this._components != null && this._components.length > n) {
            if (this._components[n] == null) {
                this._components[n] = new Property("Component", PropertyType.PROPERTY, PropertyArity.LIST, new LinkedList());
            }
            List list = (List)this._components[n].getValue();
            list.add(property);
        }
    }
}

