#!/bin/sh
#		drawgram <treefile>
# 'draw' the tree to a file using phylip program drawgram
#	"fontfile" must be in the current directory

# make a file with responses to drawgram interactive questions
# tree format to be XBM (suitable for WWW)
# calculate resolution according to number of size (number of seqs) in the tree
# the formula is a rough estimate that gave satisfactory images viewed on a Mac NetScape
#    @ resoltion = 500 now, change it to be a function of the number of
#	lines in $1, try 8 or 9 times that number (wc -l $1)

#    echo "X"         >  "drawgram.$$" # X - 'X bitmap (XBM)'
#    echo "N"         >> "drawgram.$$" # N - No preview
#    echo $resolution >> "drawgram.$$" # XBM horizontal resolution
#    echo $resolution >> "drawgram.$$" # XBM vertical resolution
#    echo "1"         >> "drawgram.$$" # Tree growth, toggle to horizontal
#    echo "2"         >> "drawgram.$$" # Style of tree
#    echo "P"         >> "drawgram.$$" # P for Phenogram style
#    echo "4"         >> "drawgram.$$" # Angle of labels
#    echo "90"        >> "drawgram.$$" # labels 90 degrees to the tree
#    echo "8"         >> "drawgram.$$" # Stem-length/tree-depth
#    echo "0"         >> "drawgram.$$" # 0 stem won't show
#    echo "Y"         >> "drawgram.$$" # Y(es) to accept choices 

#  NOTE:  Used to "mv $1 treefile.$$" so it gets deleted at end, but if
#         do that user can't hit the tree button again
if [ -f "fontfile" ]; then
   if [ -f "$1" ]; then
      \cp "$1" "treefile.$$"
      ./drawgram $$ < "drawgram.xbm.in" > /dev/null
      if [ -f "plotfile.$$" ]; then
         echo Content-type: image/x-xbitmap
         echo
         cat "plotfile.$$"
      else
         echo Content-type: text/html
         echo
         echo "Tree Error: drawgram produced no plotfile"
      fi
      \rm *.$$
   else
      echo Content-type: text/html
      echo
      echo "Tree Error: Input file $1 not found"
   fi
else
   echo Content-type: text/html
   echo
   echo "Tree Error: drawgram needs fontfile"
fi
exit


