/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.http.client;

import com.google.gwt.http.client.Header;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestTimeoutException;
import com.google.gwt.http.client.Response;
import com.google.gwt.http.client.StringValidator;
import com.google.gwt.user.client.Timer;
import com.google.gwt.xhr.client.XMLHttpRequest;

public class Request {
    private final int timeoutMillis;
    private final Timer timer;
    private XMLHttpRequest xmlHttpRequest;

    private static Response createResponse(final XMLHttpRequest xmlHttpRequest) {
        assert (Request.isResponseReady(xmlHttpRequest));
        Response response = new Response(){

            public String getHeader(String header) {
                StringValidator.throwIfEmptyOrNull("header", header);
                return xmlHttpRequest.getResponseHeader(header);
            }

            public Header[] getHeaders() {
                return Request.getHeaders(xmlHttpRequest);
            }

            public String getHeadersAsString() {
                return xmlHttpRequest.getAllResponseHeaders();
            }

            public int getStatusCode() {
                return xmlHttpRequest.getStatus();
            }

            public String getStatusText() {
                return xmlHttpRequest.getStatusText();
            }

            public String getText() {
                return xmlHttpRequest.getResponseText();
            }
        };
        return response;
    }

    private static Header[] getHeaders(XMLHttpRequest xmlHttp) {
        String allHeaders = xmlHttp.getAllResponseHeaders();
        String[] unparsedHeaders = allHeaders.split("\n");
        Header[] parsedHeaders = new Header[unparsedHeaders.length];
        for (String unparsedHeader : unparsedHeaders) {
            Header header;
            int endOfNameIdx;
            if (unparsedHeader.length() == 0 || (endOfNameIdx = unparsedHeader.indexOf(58)) < 0) continue;
            final String name = unparsedHeader.substring(0, endOfNameIdx).trim();
            final String value = unparsedHeader.substring(endOfNameIdx + 1).trim();
            parsedHeaders[i] = header = new Header(){

                public String getName() {
                    return name;
                }

                public String getValue() {
                    return value;
                }

                public String toString() {
                    return name + " : " + value;
                }
            };
        }
        return parsedHeaders;
    }

    private static boolean isResponseReady(XMLHttpRequest xhr) {
        return xhr.getReadyState() == 4;
    }

    protected Request() {
        this.timeoutMillis = 0;
        this.xmlHttpRequest = null;
        this.timer = null;
    }

    Request(XMLHttpRequest xmlHttpRequest, int timeoutMillis, final RequestCallback callback) {
        if (xmlHttpRequest == null) {
            throw new NullPointerException();
        }
        if (callback == null) {
            throw new NullPointerException();
        }
        if (timeoutMillis < 0) {
            throw new IllegalArgumentException();
        }
        this.timeoutMillis = timeoutMillis;
        this.xmlHttpRequest = xmlHttpRequest;
        if (timeoutMillis > 0) {
            this.timer = new Timer(){

                public void run() {
                    Request.this.fireOnTimeout(callback);
                }
            };
            this.timer.schedule(timeoutMillis);
        } else {
            this.timer = null;
        }
    }

    public void cancel() {
        if (this.xmlHttpRequest != null) {
            XMLHttpRequest xmlHttp = this.xmlHttpRequest;
            this.xmlHttpRequest = null;
            xmlHttp.clearOnReadyStateChange();
            xmlHttp.abort();
            this.cancelTimer();
        }
    }

    public boolean isPending() {
        if (this.xmlHttpRequest == null) {
            return false;
        }
        int readyState = this.xmlHttpRequest.getReadyState();
        switch (readyState) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    void fireOnResponseReceived(RequestCallback callback) {
        if (this.xmlHttpRequest == null) {
            return;
        }
        this.cancelTimer();
        XMLHttpRequest xhr = this.xmlHttpRequest;
        this.xmlHttpRequest = null;
        String errorMsg = this.getBrowserSpecificFailure(xhr);
        if (errorMsg != null) {
            RuntimeException exception = new RuntimeException(errorMsg);
            callback.onError(this, exception);
        } else {
            Response response = Request.createResponse(xhr);
            callback.onResponseReceived(this, response);
        }
    }

    private void cancelTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    private void fireOnTimeout(RequestCallback callback) {
        if (this.xmlHttpRequest == null) {
            return;
        }
        this.cancel();
        callback.onError(this, new RequestTimeoutException(this, this.timeoutMillis));
    }

    private native String getBrowserSpecificFailure(XMLHttpRequest var1);
}

