/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.net.URI;
import java.net.URISyntaxException;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.GlobalParameterSet;
import net.sf.saxon.instruct.GlobalVariable;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.DocumentPool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public final class Bindery {
    private ValueRepresentation[] globals;
    private boolean[] busy;
    private GlobalParameterSet globalParameters;
    private SlotManager globalVariableMap;

    public void allocateGlobals(SlotManager map) {
        this.globalVariableMap = map;
        int n = map.getNumberOfVariables() + 1;
        this.globals = new ValueRepresentation[n];
        this.busy = new boolean[n];
        for (int i = 0; i < n; ++i) {
            this.globals[i] = null;
            this.busy[i] = false;
        }
    }

    public void defineGlobalParameters(GlobalParameterSet params) {
        this.globalParameters = params;
    }

    public boolean useGlobalParameter(StructuredQName qName, int slot, SequenceType requiredType, XPathContext context) throws XPathException {
        Value val;
        if (this.globals[slot] != null) {
            return true;
        }
        if (this.globalParameters == null) {
            return false;
        }
        Object obj = this.globalParameters.get(qName);
        if (obj == null) {
            return false;
        }
        if (obj instanceof DocumentInfo) {
            String systemId = ((DocumentInfo)obj).getSystemId();
            try {
                DocumentPool pool;
                if (systemId != null && new URI(systemId).isAbsolute() && (pool = context.getController().getDocumentPool()).find(systemId) == null) {
                    pool.add((DocumentInfo)obj, systemId);
                }
            }
            catch (URISyntaxException err) {
                // empty catch block
            }
        }
        if ((val = Value.convertJavaObjectToXPath(obj, requiredType, context)) == null) {
            val = EmptySequence.getInstance();
        }
        ItemType reqItemType = requiredType.getPrimaryType();
        if (val instanceof AtomicValue && reqItemType.isAtomicType()) {
            val = ((AtomicValue)val).convert((AtomicType)reqItemType, true, context).asAtomic();
        } else {
            XPathException err = TypeChecker.testConformance(val, requiredType, context);
            if (err != null) {
                throw err;
            }
        }
        this.globals[slot] = val;
        return true;
    }

    public void defineGlobalVariable(GlobalVariable binding, ValueRepresentation value) {
        this.globals[binding.getSlotNumber()] = value;
    }

    public void setExecuting(GlobalVariable binding, boolean executing) throws XPathException {
        int slot = binding.getSlotNumber();
        if (executing) {
            if (this.busy[slot]) {
                throw new XPathException.Circularity("Circular definition");
            }
            this.busy[slot] = true;
        } else {
            this.busy[slot] = false;
        }
    }

    public ValueRepresentation getGlobalVariableValue(GlobalVariable binding) {
        return this.globals[binding.getSlotNumber()];
    }

    public ValueRepresentation getGlobalVariable(int slot) {
        return this.globals[slot];
    }

    public void setGlobalVariable(int slot, ValueRepresentation value) {
        this.globals[slot] = value;
    }

    public void assignGlobalVariable(GlobalVariable binding, ValueRepresentation value) {
        this.defineGlobalVariable(binding, value);
    }

    public SlotManager getGlobalVariableMap() {
        return this.globalVariableMap;
    }

    public ValueRepresentation[] getGlobalVariables() {
        return this.globals;
    }
}

