; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -instcombine -S < %s | FileCheck %s

target datalayout = "e-m:e-i64:64-n8:16:32:64"

declare i32 @llvm.cttz.i32(i32, i1) nounwind readnone
declare i32 @llvm.ctlz.i32(i32, i1) nounwind readnone
declare i32 @llvm.ctpop.i32(i32) nounwind readnone
declare <2 x i8> @llvm.cttz.v2i8(<2 x i8>, i1) nounwind readnone
declare <2 x i8> @llvm.ctlz.v2i8(<2 x i8>, i1) nounwind readnone
declare <2 x i8> @llvm.ctpop.v2i8(<2 x i8>) nounwind readnone

define i32 @lshr_ctlz_zero_is_not_undef(i32 %x) {
; CHECK-LABEL: @lshr_ctlz_zero_is_not_undef(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i32 %x, 0
; CHECK-NEXT:    [[SH:%.*]] = zext i1 [[TMP1]] to i32
; CHECK-NEXT:    ret i32 [[SH]]
;
  %ct = call i32 @llvm.ctlz.i32(i32 %x, i1 false)
  %sh = lshr i32 %ct, 5
  ret i32 %sh
}

define i32 @lshr_cttz_zero_is_not_undef(i32 %x) {
; CHECK-LABEL: @lshr_cttz_zero_is_not_undef(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i32 %x, 0
; CHECK-NEXT:    [[SH:%.*]] = zext i1 [[TMP1]] to i32
; CHECK-NEXT:    ret i32 [[SH]]
;
  %ct = call i32 @llvm.cttz.i32(i32 %x, i1 false)
  %sh = lshr i32 %ct, 5
  ret i32 %sh
}

define i32 @lshr_ctpop(i32 %x) {
; CHECK-LABEL: @lshr_ctpop(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i32 %x, -1
; CHECK-NEXT:    [[SH:%.*]] = zext i1 [[TMP1]] to i32
; CHECK-NEXT:    ret i32 [[SH]]
;
  %ct = call i32 @llvm.ctpop.i32(i32 %x)
  %sh = lshr i32 %ct, 5
  ret i32 %sh
}

define <2 x i8> @lshr_ctlz_zero_is_not_undef_splat_vec(<2 x i8> %x) {
; CHECK-LABEL: @lshr_ctlz_zero_is_not_undef_splat_vec(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq <2 x i8> %x, zeroinitializer
; CHECK-NEXT:    [[SH:%.*]] = zext <2 x i1> [[TMP1]] to <2 x i8>
; CHECK-NEXT:    ret <2 x i8> [[SH]]
;
  %ct = call <2 x i8> @llvm.ctlz.v2i8(<2 x i8> %x, i1 false)
  %sh = lshr <2 x i8> %ct, <i8 3, i8 3>
  ret <2 x i8> %sh
}

define <2 x i8> @lshr_cttz_zero_is_not_undef_splat_vec(<2 x i8> %x) {
; CHECK-LABEL: @lshr_cttz_zero_is_not_undef_splat_vec(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq <2 x i8> %x, zeroinitializer
; CHECK-NEXT:    [[SH:%.*]] = zext <2 x i1> [[TMP1]] to <2 x i8>
; CHECK-NEXT:    ret <2 x i8> [[SH]]
;
  %ct = call <2 x i8> @llvm.cttz.v2i8(<2 x i8> %x, i1 false)
  %sh = lshr <2 x i8> %ct, <i8 3, i8 3>
  ret <2 x i8> %sh
}

define <2 x i8> @lshr_ctpop_splat_vec(<2 x i8> %x) {
; CHECK-LABEL: @lshr_ctpop_splat_vec(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq <2 x i8> %x, <i8 -1, i8 -1>
; CHECK-NEXT:    [[SH:%.*]] = zext <2 x i1> [[TMP1]] to <2 x i8>
; CHECK-NEXT:    ret <2 x i8> [[SH]]
;
  %ct = call <2 x i8> @llvm.ctpop.v2i8(<2 x i8> %x)
  %sh = lshr <2 x i8> %ct, <i8 3, i8 3>
  ret <2 x i8> %sh
}

define i8 @lshr_exact(i8 %x) {
; CHECK-LABEL: @lshr_exact(
; CHECK-NEXT:    [[SHL:%.*]] = shl i8 %x, 2
; CHECK-NEXT:    [[ADD:%.*]] = add i8 [[SHL]], 4
; CHECK-NEXT:    [[LSHR:%.*]] = lshr exact i8 [[ADD]], 2
; CHECK-NEXT:    ret i8 [[LSHR]]
;
  %shl = shl i8 %x, 2
  %add = add i8 %shl, 4
  %lshr = lshr i8 %add, 2
  ret i8 %lshr
}

define <2 x i8> @lshr_exact_splat_vec(<2 x i8> %x) {
; CHECK-LABEL: @lshr_exact_splat_vec(
; CHECK-NEXT:    [[SHL:%.*]] = shl <2 x i8> %x, <i8 2, i8 2>
; CHECK-NEXT:    [[ADD:%.*]] = add <2 x i8> [[SHL]], <i8 4, i8 4>
; CHECK-NEXT:    [[LSHR:%.*]] = lshr exact <2 x i8> [[ADD]], <i8 2, i8 2>
; CHECK-NEXT:    ret <2 x i8> [[LSHR]]
;
  %shl = shl <2 x i8> %x, <i8 2, i8 2>
  %add = add <2 x i8> %shl, <i8 4, i8 4>
  %lshr = lshr <2 x i8> %add, <i8 2, i8 2>
  ret <2 x i8> %lshr
}

define i16 @bool_zext(i1 %x) {
; CHECK-LABEL: @bool_zext(
; CHECK-NEXT:    [[HIBIT:%.*]] = zext i1 %x to i16
; CHECK-NEXT:    ret i16 [[HIBIT]]
;
  %sext = sext i1 %x to i16
  %hibit = lshr i16 %sext, 15
  ret i16 %hibit
}

define <2 x i8> @bool_zext_splat(<2 x i1> %x) {
; CHECK-LABEL: @bool_zext_splat(
; CHECK-NEXT:    [[HIBIT:%.*]] = zext <2 x i1> %x to <2 x i8>
; CHECK-NEXT:    ret <2 x i8> [[HIBIT]]
;
  %sext = sext <2 x i1> %x to <2 x i8>
  %hibit = lshr <2 x i8> %sext, <i8 7, i8 7>
  ret <2 x i8> %hibit
}

define i32 @smear_sign_and_widen(i8 %x) {
; CHECK-LABEL: @smear_sign_and_widen(
; CHECK-NEXT:    [[TMP1:%.*]] = ashr i8 %x, 7
; CHECK-NEXT:    [[HIBIT:%.*]] = zext i8 [[TMP1]] to i32
; CHECK-NEXT:    ret i32 [[HIBIT]]
;
  %sext = sext i8 %x to i32
  %hibit = lshr i32 %sext, 24
  ret i32 %hibit
}

define i16 @smear_sign_and_widen_should_not_change_type(i4 %x) {
; CHECK-LABEL: @smear_sign_and_widen_should_not_change_type(
; CHECK-NEXT:    [[SEXT:%.*]] = sext i4 %x to i16
; CHECK-NEXT:    [[HIBIT:%.*]] = lshr i16 [[SEXT]], 12
; CHECK-NEXT:    ret i16 [[HIBIT]]
;
  %sext = sext i4 %x to i16
  %hibit = lshr i16 %sext, 12
  ret i16 %hibit
}

define <2 x i8> @smear_sign_and_widen_splat(<2 x i6> %x) {
; CHECK-LABEL: @smear_sign_and_widen_splat(
; CHECK-NEXT:    [[TMP1:%.*]] = ashr <2 x i6> %x, <i6 2, i6 2>
; CHECK-NEXT:    [[HIBIT:%.*]] = zext <2 x i6> [[TMP1]] to <2 x i8>
; CHECK-NEXT:    ret <2 x i8> [[HIBIT]]
;
  %sext = sext <2 x i6> %x to <2 x i8>
  %hibit = lshr <2 x i8> %sext, <i8 2, i8 2>
  ret <2 x i8> %hibit
}

define i18 @fake_sext(i3 %x) {
; CHECK-LABEL: @fake_sext(
; CHECK-NEXT:    [[TMP1:%.*]] = lshr i3 %x, 2
; CHECK-NEXT:    [[SH:%.*]] = zext i3 [[TMP1]] to i18
; CHECK-NEXT:    ret i18 [[SH]]
;
  %sext = sext i3 %x to i18
  %sh = lshr i18 %sext, 17
  ret i18 %sh
}

; Avoid the transform if it would change the shift from a legal to illegal type.

define i32 @fake_sext_but_should_not_change_type(i3 %x) {
; CHECK-LABEL: @fake_sext_but_should_not_change_type(
; CHECK-NEXT:    [[SEXT:%.*]] = sext i3 %x to i32
; CHECK-NEXT:    [[SH:%.*]] = lshr i32 [[SEXT]], 31
; CHECK-NEXT:    ret i32 [[SH]]
;
  %sext = sext i3 %x to i32
  %sh = lshr i32 %sext, 31
  ret i32 %sh
}

define <2 x i8> @fake_sext_splat(<2 x i3> %x) {
; CHECK-LABEL: @fake_sext_splat(
; CHECK-NEXT:    [[TMP1:%.*]] = lshr <2 x i3> %x, <i3 2, i3 2>
; CHECK-NEXT:    [[SH:%.*]] = zext <2 x i3> [[TMP1]] to <2 x i8>
; CHECK-NEXT:    ret <2 x i8> [[SH]]
;
  %sext = sext <2 x i3> %x to <2 x i8>
  %sh = lshr <2 x i8> %sext, <i8 7, i8 7>
  ret <2 x i8> %sh
}

