.\" dpkg manual page - dsc(5)
.\"
.\" Copyright © 1995-1996 Ian Jackson <ijackson@chiark.greenend.org.uk>
.\" Copyright © 2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dsc 5 %RELEASE_DATE% %VERSION% dpkg\-Programmsammlung
.nh
.SH BEZEICHNUNG
dsc \- Format der Quellpaketsteuerdatei von Debian
.
.SH ÜBERSICHT
\fIDateiname\fP\fB.dsc\fP
.
.SH BESCHREIBUNG
Jedes Debian\-Quellpaket besteht aus einer .dsc\-Steuerdatei, die eine Reihe
von Feldern enthält.Jedes Feld beginnt mit einer Markierung, wie \fBSource\fP
oder \fBBinary\fP (Groß\-/Kleinschreibung egal), gefolgt von einem Doppelpunkt
und dem Körper des Feldes. Felder werden nur durch die Feldmarkierungen
abgegrenzt. Mit anderen Worten, Feldtexte können mehrere Zeilen überspannen,
aber die Installationswerkzeuge werden im Allgemeinen die Zeilen bei der
Verarbeitung des Feldkörpers zusammenfassen (mit Ausnahme der mehrzeiligen
Felder \fBPackage\-List\fP, \fBFiles\fP, \fBChecksums\-Sha1\fP und \fBChecksums\-Sha256\fP,
sehen Sie dazu unten).
.PP
Die Steuerdaten können in eine Signatur mit einer wie in RFC4880
spezifizierten OpenPGP\-ASCII\-Hülle eingeschlossen sein.
.
.SH FELDER
.TP 
\fBFormat:\fP \fIFormatversion\fP (verpflichtend)
Der Wert des Feldes gibt die Formatversion des Quellpaketes an. Der Feldwert
wird von Programmen, die mit Quellpaketen arbeiten, verwandt, um die Liste
der Dateien in dem Quellpaket zu interpretieren und zu bestimmen, wie es
entpackt wird. Die Syntax des Feldwertes ist eine numerische Hauptrevision,
ein Satzpunkt, eine numerische Unterrevision und dann ein optionaler
Untertyp nach einem Leerzeichen. Falls dieser spezifiziert wird, ist er ein
alphanumerisches Wort in Anführungszeichen. Der Untertyp ist in der Syntax
optional, kann aber für eine bestimmte Quellformatrevision verpflichtend
sein.

Die von \fBdpkg\fP derzeit unterstützten Quellformate sind \fB1.0\fP, \fB2.0\fP,
\fB3.0 (native)\fP, \fB3.0 (quilt)\fP, \fB3.0 (git)\fP, \fB3.0 (bzr)\fP und \fB3.0
(custom)\fP.
.TP 
\fBSource:\fP \fIQuellname\fP (verpflichtend)
Der Wert dieses Feldes bestimmt den Paketnamen und wird von den meisten
Installationswerkzeugen verwendet, um Dateinamen zu erstellen.
.TP 
\fBBinary:\fP\fI Binär\-Paketliste\fP
Dieses gefaltete Feld führt durch Kommata getrennte Binärpakete auf, die
dieses Quellpaket erstellen kann.

Dieses Feld wurde jetzt durch das Feld \fBPackage\-List\fP ersetzt, das genug
Informationen darüber, welche binären Pakete auf welcher Architektur
erstellt werden sowie Bauprofile und andere zugehörige Einschränkungen,
gibt.
.TP 
\fBArchitecture:\fP \fIArchitekturliste\fP (empfohlen)
Eine durch Leerzeichen getrennte Liste von Architekturen und
Architekturplatzhaltern, die den Typ der Hardware festlegen, für die das
Paket übersetzt werden kann. Typische Architekturnamen und
Architekturplatzhalter sind \fBamd64\fP, \fBarmel\fP, \fBi386\fP, \fBlinux\-any\fP,
\fBany\-amd64\fP usw.

Beachten Sie, dass der Wert \fBall\fP für Pakete gedacht ist, die unabhängig
von der Achitektur sind und \fBany\fP für Pakete, die architekturabhängig
sind. Die Liste kann den Wert \fBall\fP enthalten oder aus ihm alleine
bestehen. Wenn die Liste den Architekturplatzhalter \fBany\fP enthält, ist der
einzig andere in der Liste erlaubte Wert \fBall\fP.

Der Feldwert wird im Allgemeinen aus den \fBArchitecture\fP\-Feldern aus der
\fIdebian/control\fP des Quellpaketes erstellt.
.TP 
\fBVersion:\fP \fIVersionszeichenkette\fP (verpflichtend)
Typischerweise ist das die Original\-Paketversionsnummer, in der Form, die
der Programmautor verwendet. Es kann auch eine Debian\-Revisionsnummer
enthalten (für nicht aus Debian stammende Pakete). Das genaue Format und der
Sortieralgorithmus sind in \fBdeb\-version\fP(7) beschrieben.
.TP 
\fBOrigin:\fP\fI Name\fP
Der Name der Distribution, aus der dieses Paket ursprünglich stammt.
.TP 
\fBMaintainer:\fP \fIVollständiger\-Name\-und\-E\-Mail\fP (empfohlen)
Sollte in dem Format „Joe Bloggs <jbloggs@foo.com>“ sein und ist
typischerweise die Person, die das Paket erstellt hat, im Gegensatz zum
Autor der Software, die paketiert wurde.
.TP 
\fBUploaders:\fP\fI Vollständiger\-Name\-und\-E\-Mail\-Liste\fP
Listet die Namen und E\-Mail\-Adressen der Ko\-Betreuer des Pakets auf, im
gleichen Format wie das Feld \fBMaintainer\fP. Mehrere Ko\-Betreuer sollten
durch Kommata getrennt werden.
.TP 
\fBDescription\fP\fI short\-description\fP
.TQ
\fB \fP\fILangbeschreibung\fP
The format for the source package description is a short brief summary on
the first line (after the \fBDescription\fP field).  The following lines should
be used as a longer, more detailed description.  Each line of the long
description must be preceded by a space, and blank lines in the long
description must contain a single ‘\fB.\fP’ following the preceding space.
.TP 
\fBHomepage:\fP\fI URL\fP
Die \fIURL\fP des Original\- (Upstream\-)Projekts.
.TP 
\fBStandards\-Version:\fP \fI Versionszeichenkette\fP (empfohlen)
Dies dokumentiert die neuste Version der Standards der Distribution, an den
sich das Paket hält.
.TP 
\fBVcs\-Browser:\fP\fI URL\fP
Die \fIURL\fP der Webschnittstelle, um das Versionskontrollsystem\-Depot
anzuschauen.
.TP 
\fBVcs\-Arch*:\fP\fI URL\fP
.TQ
\fBVcs\-Bzr:\fP\fI URL\fP
.TQ
\fBVcs\-Cvs:\fP\fI URL\fP
.TQ
\fBVcs\-Darcs:\fP\fI URL\fP
.TQ
\fBVcs\-Git:\fP\fI URL\fP
.TQ
\fBVcs\-Hg:\fP\fI URL\fP
.TQ
\fBVcs\-Mtn:\fP\fI URL\fP
.TQ
\fBVcs\-Svn:\fP\fI URL\fP
Diese Felder verkünden die \fIURL\fP des Versionskontrollsystem\-Depots, das für
die Betreuung des Pakets verwandt wird. Siehe \fBdeb\-src\-control\fP(5) für
weitere Details.
.TP 
\fBTestsuite:\fP\fI Namenliste\fP
Dieses Feld verkündigt, dass das Quellpaket die angegebene Testsammlung
enthält. Der Wert ist eine durch Kommata getrennte Liste von
Testsammlungen. Falls der Wert \fBautopkgtest\fP vorkommt, wird erwartet, dass
\fIdebian/tests/control\fP vorhanden ist. Falls nur die Datei aber nicht der
Wert vorhanden ist, wird \fBdpkg\-source\fP den Wert automatisch (unter
Beibehaltung der vorherigen Werte) hinzufügen.
.TP 
\fBTestsuite\-Triggers:\fP\fI Paketliste\fP
This field declares the comma\-separated union of all test dependencies
(\fBDepends\fP fields in \fIdebian/tests/control\fP file), with all restrictions
removed, and OR dependencies flattened, except for binaries generated by
this source package and meta\-dependencies such as \fB@\fP or \fB@builddeps@\fP.

Hintergrund: Dieses Feld wird benötigt, da andernfalls jedes Quellpaket
entpackt werden müsste, um die Testabhängigkeiten zu ermitteln.
.TP 
\fBBuild\-Depends:\fP\fI Paketliste\fP
.TQ
\fBBuild\-Depends\-Arch:\fP\fI Paketliste\fP
.TQ
\fBBuild\-Depends\-Indep:\fP\fI Paketliste\fP
.TQ
\fBBuild\-Conflicts:\fP\fI Paketliste\fP
.TQ
\fBBuild\-Conflicts\-Arch:\fP\fI Paketliste\fP
.TQ
\fBBuild\-Conflicts\-Indep:\fP\fI Paketliste\fP
Diese Felder verkünden die Beziehungen zwischen dem Quellpaket und Paketen,
die daraus gebaut werden. Sie werden in der Handbuchseite \fBdeb\-control\fP(5)
beschrieben.
.TP 
\fBPackage\-List:\fP
.TQ
 \fIPaket\fP \fIPakettyp\fP \fISektion\fP \fIPriorität\fP \fISchlüssel\-Wert\-Liste\fP
Dieses mehrzeilige Feld enthält eine Liste von Binärpaketen, die von diesem
Quellpaket erstellt werden.

Das \fIPaket\fP ist der Name des Binärpakets.

Der \fIPakettyp\fP ist der binäre Pakettyp, normalerweise \fBdeb\fP, \fBudeb\fP ist
ein anderer häufiger Wert.

\fISektion\fP und \fIPriorität\fP entsprechen den Feldern \fIsection\fP und
\fIpriority\fP des Binärpakets.

Die \fISchlüssel\-Wert\-Liste\fP ist eine durch Leerzeichen getrennte
\fISchlüssel\fP\fB=\fP\fIWert\fP\-Liste und die derzeit erkannten optionalen Schlüssel
sind:

.RS
.TP 
\fBarch\fP
Die Architektureinschränkungen aus dem Feld \fBArchitecture\fP des Binärpakets,
wobei Leerzeichen zu ‚,’ konvertiert wurden.
.TP 
\fBprofile\fP
Die normalisierte Bauprofileinschränkungsformel aus dem Feld
\fBBuild\-Profile\fP des Binärpakets, wobei »OR« in ‚+’ und »AND« in ‚,’
umgewandelt wurden.
.TP 
\fBessential\fP
Falls das Binärpaket »essential« ist, wird der Schlüssel den Wert des Feldes
\fBEssential\fP enthalten, der \fByes\fP lautet.
.RE
.TP 
\fBFiles:\fP (verpflichtend)
.TQ
\fBChecksums\-Sha1:\fP (verpflichtend)
.TQ
\fBChecksums\-Sha256:\fP (verpflichtend)
.TQ
 \fIPrüfsumme\fP \fIGröße\fP \fIDateiname\fP
Diese mehrzeiligen Felder enthalten eine Liste von Dateien mit einer
Prüfsumme und Größe für jede. Diese Felder haben die gleiche Syntax und
unterscheiden sich nur im verwandten Prüfsummenalgorithmus: MD5 für
\fBFiles\fP, SHA\-1 für \fBChecksums\-Sha1\fP und SHA\-256 für \fBChecksums\-Sha256\fP.

Die erste Zeile des Feldwertes (der Teil auf dem durch ein Doppelpunkt
gefolgten Feldnamen) ist immer leer. Der Inhalt des Feldes wird durch
Fortsetzungszeilen ausgedrückt, eine Zeile pro Datei. Jede Zeile besteht aus
der Prüfsumme, einem Leerzeichen, der Dateigröße, einem Leerzeichen und dem
Dateinamen.

Diese Felder führen alle Dateien auf, die das Quellpaket darstellen. Die
Liste der Dateien in diesen Feldern muss auf die Liste der Dateien in den
anderen dazugehörigen Feldern passen.
.
.\" .SH EXAMPLE
.\" .RS
.\" .nf
.\" .fi
.\" .RE
.
.SH FEHLER
Das Feld \fBFormat\fP fügt das Format für die Datei \fB.dsc\fP und das Format des
extrahierten Quellpakets zusammen.
.SH "SIEHE AUCH"
\fBdeb\-src\-control\fP(5), \fBdeb\-version\fP(7), \fBdpkg\-source\fP(1).
.SH ÜBERSETZUNG
Die deutsche Übersetzung wurde 2004, 2006-2017 von Helge Kreutzmann
<debian@helgefjell.de>, 2007 von Florian Rehnisch <eixman@gmx.de> und
2008 von Sven Joachim <svenjoac@gmx.de>
angefertigt. Diese Übersetzung ist Freie Dokumentation; lesen Sie die
GNU General Public License Version 2 oder neuer für die Kopierbedingungen.
Es gibt KEINE HAFTUNG.
